<?php
$hostname = 'localhost';
$username = 'root';
$password = '';
$database = 'db_activity_biodata';

try {
    $pdo = new PDO("mysql:host=$hostname;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM biodata LIKE 'tanggal_lahir'");
    if ($stmt->rowCount() == 0) {
        // Add column
        $pdo->exec("ALTER TABLE biodata ADD COLUMN tanggal_lahir DATE NULL AFTER nama");
        echo "SUCCESS: Column 'tanggal_lahir' added successfully.\n";
    } else {
        echo "INFO: Column 'tanggal_lahir' already exists.\n";
    }

    // Verify
    $stmt = $pdo->query("SHOW COLUMNS FROM biodata LIKE 'tanggal_lahir'");
    if ($stmt->rowCount() > 0) {
        echo "VERIFIED: Column exists in database schema.\n";
    } else {
        echo "ERROR: Column Check Failed after attempt.\n";
        exit(1);
    }

} catch(PDOException $e) {
    echo "DB ERROR: " . $e->getMessage() . "\n";
    exit(1);
}
