<?php

/**
 * Test script untuk aktivitas save functionality
 */

// Database configuration
$host = 'localhost';
$dbname = 'db_activity_biodata';
$username = 'root';
$password = '';

try {
    echo "=== Testing Aktivitas Save Functionality ===\n\n";
    
    // Connect to database
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✓ Database connection successful\n\n";
    
    // Test 1: Direct database insert
    echo "Test 1: Direct Database Insert\n";
    echo "--------------------------------\n";
    
    $testData = [
        'tanggal' => date('Y-m-d'),
        'nama_aktivitas' => 'Test Activity - ' . date('H:i:s'),
        'keterangan' => 'This is a test activity created at ' . date('Y-m-d H:i:s'),
        'created_at' => date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s')
    ];
    
    $stmt = $pdo->prepare("INSERT INTO aktivitas (tanggal, nama_aktivitas, keterangan, created_at, updated_at) VALUES (?, ?, ?, ?, ?)");
    $result = $stmt->execute([
        $testData['tanggal'],
        $testData['nama_aktivitas'],
        $testData['keterangan'],
        $testData['created_at'],
        $testData['updated_at']
    ]);
    
    if ($result) {
        $insertId = $pdo->lastInsertId();
        echo "✓ Direct insert successful! ID: $insertId\n";
        echo "  Tanggal: {$testData['tanggal']}\n";
        echo "  Nama: {$testData['nama_aktivitas']}\n";
        echo "  Keterangan: {$testData['keterangan']}\n\n";
    } else {
        echo "✗ Direct insert failed!\n\n";
    }
    
    // Test 2: Verify data in database
    echo "Test 2: Verify Data in Database\n";
    echo "--------------------------------\n";
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM aktivitas");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Total aktivitas records: {$result['total']}\n\n";
    
    if ($result['total'] > 0) {
        echo "Last 3 records:\n";
        $stmt = $pdo->query("SELECT * FROM aktivitas ORDER BY id DESC LIMIT 3");
        $records = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($records as $i => $record) {
            echo "\n" . ($i + 1) . ". ID: {$record['id']}\n";
            echo "   Tanggal: {$record['tanggal']}\n";
            echo "   Nama: {$record['nama_aktivitas']}\n";
            echo "   Keterangan: " . substr($record['keterangan'], 0, 50) . "...\n";
        }
    }
    
    echo "\n=== Test Complete ===\n";
    echo "\nConclusion:\n";
    echo "- Database connection: OK\n";
    echo "- Direct insert: OK\n";
    echo "- Data retrieval: OK\n";
    echo "\nIf the web form still doesn't work, check:\n";
    echo "1. Browser console for JavaScript errors\n";
    echo "2. CodeIgniter logs in writable/logs/\n";
    echo "3. CSRF token validation\n";
    echo "4. Form field names match model allowedFields\n";
    
} catch (PDOException $e) {
    echo "✗ Database Error: " . $e->getMessage() . "\n";
    exit(1);
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}
