<?php

/**
 * Script untuk memeriksa dan memperbaiki tabel aktivitas
 */

// Database configuration
$host = 'localhost';
$dbname = 'db_activity_biodata';
$username = 'root';
$password = '';

try {
    // Connect to database
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Checking Aktivitas Table ===\n\n";
    echo "Koneksi database berhasil!\n\n";
    
    // Check if aktivitas table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'aktivitas'");
    $tableExists = $stmt->rowCount() > 0;
    
    if (!$tableExists) {
        echo "Tabel 'aktivitas' tidak ditemukan. Membuat tabel...\n";
        
        $createTable = "CREATE TABLE `aktivitas` (
            `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
            `tanggal` date NOT NULL,
            `nama_aktivitas` varchar(255) NOT NULL,
            `keterangan` text NOT NULL,
            `created_at` datetime DEFAULT NULL,
            `updated_at` datetime DEFAULT NULL,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
        
        $pdo->exec($createTable);
        echo "Tabel 'aktivitas' berhasil dibuat!\n\n";
    } else {
        echo "Tabel 'aktivitas' sudah ada.\n\n";
    }
    
    // Show table structure
    echo "=== Struktur Tabel Aktivitas ===\n";
    $stmt = $pdo->query("DESCRIBE aktivitas");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($columns as $column) {
        echo "- {$column['Field']}: {$column['Type']} " . 
             ($column['Null'] == 'NO' ? '(Required)' : '(Optional)') . "\n";
    }
    
    // Count existing records
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM aktivitas");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "\n=== Data Aktivitas ===\n";
    echo "Total records: " . $result['total'] . "\n";
    
    // Show sample data if exists
    if ($result['total'] > 0) {
        echo "\nSample data (last 5 records):\n";
        $stmt = $pdo->query("SELECT * FROM aktivitas ORDER BY id DESC LIMIT 5");
        $records = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($records as $record) {
            echo "\nID: {$record['id']}\n";
            echo "Tanggal: {$record['tanggal']}\n";
            echo "Nama: {$record['nama_aktivitas']}\n";
            echo "Keterangan: " . substr($record['keterangan'], 0, 50) . "...\n";
        }
    }
    
    echo "\n=== Check Complete ===\n";
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
