<?= $this->extend('layout/template'); ?>

<?= $this->section('content'); ?>

<!-- Hero Section -->
<div class="hero-section mb-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="hero-text fade-in-up">
                    <h1 class="text-gradient-yellow mb-4">Portofolio Vanny Nurazizah</h1>
                    <p class="hero-subtext mb-4">Selamat datang di halaman portfolio digital saya. Temukan informasi
                        lengkap tentang pendidikan, aktivitas, dan perjalanan karir saya.</p>
                    <div class="d-flex gap-3">
                        <a href="#biodata" class="btn btn-yellow-gradient">
                            <i class="bi bi-person-circle me-2"></i>Lihat Biodata
                        </a>
                        <a href="#pendidikan" class="btn btn-yellow-outline">
                            <i class="bi bi-mortarboard me-2"></i>Pendidikan
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 text-center">
                <div class="mx-auto position-relative">
                    <?php
                    $nama = $biodata['nama'] ?? 'User';
                    $initials = '';
                    $words = explode(' ', trim($nama));
                    foreach ($words as $word) {
                        if (!empty($word)) {
                            $initials .= strtoupper(substr($word, 0, 1));
                        }
                    }
                    $initials = substr($initials, 0, 2);
                    if (empty($initials))
                        $initials = 'U';
                    ?>

                    <?php if (!empty($biodata['foto']) && file_exists(FCPATH . 'uploads/biodata/' . $biodata['foto'])): ?>
                        <img src="<?= base_url('uploads/biodata/' . $biodata['foto']); ?>"
                            class="img-fluid rounded shadow-lg p-1 bg-white" alt="<?= esc($nama); ?>"
                            style="max-width: 400px; object-fit: cover;">
                    <?php else: ?>
                        <div class="rounded shadow-lg d-flex align-items-center justify-content-center text-white fw-bold mx-auto p-1 bg-white"
                            style="width: 350px; height: 350px;">
                            <div class="w-100 h-100 d-flex align-items-center justify-content-center"
                                style="background: linear-gradient(135deg, #F59E0B, #FBBF24); font-size: 5rem; letter-spacing: 2px;">
                                <?= esc($initials); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-blob"></div>
</div>

<div class="row">
    <!-- Sidebar / Biodata -->
    <div class="col-lg-4 mb-4">
        <div class="card card-yellow-glow sticky-top" style="top: 100px; z-index: 1;" id="biodata">
            <div class="card-body">
                <div class="text-center mb-4">
                    <div class="position-relative d-inline-block">
                        <?php
                        $nama = $biodata['nama'] ?? 'User';
                        $initials = '';
                        $words = explode(' ', trim($nama));
                        foreach ($words as $word) {
                            if (!empty($word)) {
                                $initials .= strtoupper(substr($word, 0, 1));
                            }
                        }
                        $initials = substr($initials, 0, 2);
                        if (empty($initials))
                            $initials = 'U';
                        ?>

                        <?php if (!empty($biodata['foto']) && file_exists(FCPATH . 'uploads/biodata/' . $biodata['foto'])): ?>
                            <img src="<?= base_url('uploads/biodata/' . $biodata['foto']); ?>"
                                class="rounded border border-3"
                                style="border-color: var(--primary-color) !important; width: 120px; height: 120px; object-fit: cover;"
                                alt="<?= esc($nama); ?>">
                        <?php else: ?>
                            <div class="rounded border border-3 d-flex align-items-center justify-content-center text-white fw-bold"
                                style="border-color: var(--primary-color) !important; width: 120px; height: 120px; background: linear-gradient(135deg, #8b5cf6, #a855f7); font-size: 2.5rem; letter-spacing: 1px;">
                                <?= esc($initials); ?>
                            </div>
                        <?php endif; ?>
                        <span class="position-absolute bottom-0 end-0 bg-success rounded-circle p-2"
                            style="width: 20px; height: 20px;"></span>
                    </div>
                </div>

                <?php if ($biodata): ?>
                    <div class="text-center mb-4">
                        <h3 class="text-gradient-yellow mb-2"><?= esc($biodata['nama']); ?></h3>
                        <p class="text-muted mb-0">
                            <i class="bi bi-envelope-fill text-primary me-2"></i><?= esc($biodata['email']); ?>
                        </p>
                    </div>

                    <div class="bg-gradient-yellow-soft rounded-3 p-3 mb-3">
                        <div class="d-flex align-items-start mb-3">
                            <div class="icon-box-modern me-3">
                                <i class="bi bi-calendar-heart-fill"></i>
                            </div>
                            <div>
                                <h6 class="text-primary mb-1">Tanggal Lahir</h6>
                                <p class="mb-0 small text-muted">
                                    <?php
                                    if (!empty($biodata['tanggal_lahir'])) {
                                        echo date('d F Y', strtotime($biodata['tanggal_lahir']));
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </p>
                            </div>
                        </div>

                        <div class="d-flex align-items-start mb-3">
                            <div class="icon-box-modern me-3">
                                <i class="bi bi-geo-alt-fill"></i>
                            </div>
                            <div>
                                <h6 class="text-primary mb-1">Alamat</h6>
                                <p class="mb-0 small text-muted"><?= nl2br(esc($biodata['alamat'])); ?></p>
                            </div>
                        </div>

                        <div class="d-flex align-items-start mb-3">
                            <div class="icon-box-modern me-3">
                                <i class="bi bi-phone-fill"></i>
                            </div>
                            <div>
                                <h6 class="text-primary mb-1">No. Handphone</h6>
                                <p class="mb-0 small text-muted"><?= esc($biodata['no_hp']); ?></p>
                            </div>
                        </div>

                        <div class="d-flex align-items-start">
                            <div class="icon-box-modern me-3">
                                <i class="bi bi-person-lines-fill"></i>
                            </div>
                            <div>
                                <h6 class="text-primary mb-1">Tentang Saya</h6>
                                <p class="mb-0 small text-muted"><?= nl2br(esc($biodata['riwayat_singkat'])); ?></p>
                            </div>
                        </div>
                    </div>

                    <div class="d-grid">
                        <a href="/biodata" class="btn btn-yellow-outline btn-sm">
                            <i class="bi bi-eye me-2"></i>Lihat Detail Biodata
                        </a>
                    </div>
                <?php else: ?>
                    <div class="alert alert-yellow text-center">
                        <i class="bi bi-exclamation-triangle-fill fs-1 mb-3 d-block"></i>
                        <h5>Biodata Belum Diisi</h5>
                        <p class="mb-0">Silakan lengkapi biodata Anda terlebih dahulu.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Main Content: Education & Activities -->
    <div class="col-lg-8">

        <!-- Pendidikan Section -->
        <div class="card card-yellow-glow mb-4 fade-in-up delay-100" id="pendidikan">
            <div class="card-header bg-gradient-yellow-vibrant text-white border-0 py-4">
                <div class="d-flex align-items-center">
                    <div class="icon-box-modern me-3" style="background: rgba(255,255,255,0.2); color: white;">
                        <i class="bi bi-mortarboard-fill"></i>
                    </div>
                    <div>
                        <h4 class="mb-0">Riwayat Pendidikan</h4>
                        <p class="mb-0 opacity-75">Perjalanan pendidikan formal</p>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <?php if (empty($pendidikan)): ?>
                    <div class="p-4 text-center">
                        <i class="bi bi-mortarboard text-muted fs-1 mb-3 d-block"></i>
                        <h5 class="text-muted">Belum Ada Data Pendidikan</h5>
                        <p class="text-muted mb-0">Data pendidikan akan ditampilkan di sini.</p>
                    </div>
                <?php else: ?>
                    <div class="timeline timeline-yellow p-4">
                        <?php foreach ($pendidikan as $index => $edu): ?>
                            <div class="timeline-item fade-in-up" style="animation-delay: <?= ($index + 1) * 0.1 ?>s;">
                                <div class="timeline-dot">
                                    <i class="bi bi-mortarboard-fill"></i>
                                </div>
                                <div class="timeline-content">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <h5 class="text-primary mb-0"><?= esc($edu['nama_sekolah']); ?></h5>
                                        <span class="badge badge-yellow"><?= esc($edu['tahun_masuk']); ?> -
                                            <?= esc($edu['tahun_lulus']); ?></span>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <span class="badge bg-light text-dark me-2">
                                            <i class="bi bi-bookmark-fill me-1"></i><?= esc($edu['jenjang']); ?>
                                        </span>
                                        <small class="text-muted">
                                            <i class="bi bi-calendar-event me-1"></i>
                                            <?= (intval($edu['tahun_lulus']) - intval($edu['tahun_masuk'])); ?> tahun
                                        </small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="card-footer bg-light border-0">
                <div class="d-flex justify-content-between align-items-center">
                    <small class="text-muted">
                        <i class="bi bi-info-circle me-1"></i>
                        Total: <?= count($pendidikan); ?> jenjang pendidikan
                    </small>
                    <a href="/pendidikan" class="btn btn-yellow-outline btn-sm">
                        <i class="bi bi-eye me-1"></i>Lihat Detail
                    </a>
                </div>
            </div>
        </div>

        <!-- Aktivitas Section -->
        <div class="card card-yellow-glow fade-in-up delay-200">
            <div class="card-header bg-gradient-yellow-dark text-white border-0 py-4">
                <div class="d-flex align-items-center">
                    <div class="icon-box-modern me-3" style="background: rgba(255,255,255,0.2); color: white;">
                        <i class="bi bi-activity"></i>
                    </div>
                    <div>
                        <h4 class="mb-0">Aktivitas Terkini</h4>
                        <p class="mb-0 opacity-75">Kegiatan dan pencapaian harian</p>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <?php if (empty($aktivitas)): ?>
                    <div class="text-center py-5">
                        <i class="bi bi-calendar-x text-muted fs-1 mb-3 d-block"></i>
                        <h5 class="text-muted">Belum Ada Aktivitas</h5>
                        <p class="text-muted mb-4">Aktivitas harian akan ditampilkan di sini.</p>
                        <a href="/aktivitas" class="btn btn-yellow-outline">
                            <i class="bi bi-plus-circle me-2"></i>Tambah Aktivitas
                        </a>
                    </div>
                <?php else: ?>
                    <div class="row g-4">
                        <?php foreach (array_slice($aktivitas, 0, 6) as $index => $act): ?>
                            <div class="col-md-6">
                                <div class="card card-yellow-glow h-100 hover-card fade-in-up"
                                    style="animation-delay: <?= ($index + 1) * 0.1 ?>s;">
                                    <div class="card-body p-4 d-flex flex-column">
                                        <!-- Header with Icon and Date -->
                                        <div class="d-flex align-items-center justify-content-between mb-3">
                                            <div class="icon-box-modern flex-shrink-0">
                                                <i class="bi bi-activity"></i>
                                            </div>
                                            <span class="badge badge-yellow rounded-pill ms-2 flex-shrink-0">
                                                <i class="bi bi-calendar-event me-1"></i>
                                                <?= date('d M', strtotime($act['tanggal'])); ?>
                                            </span>
                                        </div>

                                        <!-- Activity Title -->
                                        <h5 class="text-gradient-yellow fw-bold mb-3 lh-sm">
                                            <?= esc($act['nama_aktivitas']); ?>
                                        </h5>

                                        <!-- Activity Description -->
                                        <?php if (!empty($act['keterangan'])): ?>
                                            <div class="bg-gradient-yellow-soft rounded-3 p-3 mb-3 flex-grow-1">
                                                <p class="mb-0 small text-muted line-clamp-3">
                                                    <?= nl2br(esc($act['keterangan'])); ?>
                                                </p>
                                            </div>
                                        <?php endif; ?>

                                        <!-- Footer -->
                                        <div class="d-flex justify-content-between align-items-center mt-auto pt-3 border-top"
                                            style="border-color: rgba(139, 92, 246, 0.1) !important;">
                                            <small class="text-muted">
                                                <i class="bi bi-clock me-1"></i>
                                                <?= date('d M Y', strtotime($act['tanggal'])); ?>
                                            </small>
                                            <div class="progress progress-yellow" style="width: 50px; height: 3px;">
                                                <div class="progress-bar" style="width: 100%;"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?php if (count($aktivitas) > 6): ?>
                        <div class="text-center mt-4">
                            <a href="/aktivitas" class="btn btn-yellow-gradient">
                                <i class="bi bi-eye me-2"></i>Lihat Semua Aktivitas (<?= count($aktivitas); ?>)
                            </a>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>

    </div>
</div>

<?= $this->endSection(); ?>