<?= $this->extend('layout/template'); ?>

<?= $this->section('content'); ?>

<?php if ($biodata): ?>
    <!-- Hero Section -->
    <div class="hero-section reveal">
        <div class="row align-items-center">
            <!-- Left Column: Text -->
            <div class="col-lg-6 mb-5 mb-lg-0 hero-text">
                <div class="badge badge-pink rounded-pill px-4 py-2 mb-3 fw-bold">
                    <i class="bi bi-person-circle me-2"></i>Portofolio Digital
                </div>
                <h1 class="display-3 fw-bold mb-3 text-gradient-pink lh-sm">
                    <?= esc($biodata['nama']); ?>
                </h1>
                <p class="lead text-secondary mb-4 opacity-75">
                    <?= nl2br(esc($biodata['riwayat_singkat'])); ?>
                </p>
                <div class="d-flex gap-3 flex-wrap">
                    <a href="#contact" class="btn btn-pink-gradient btn-lg rounded-pill px-5 shadow-lg fw-bold">
                        <i class="bi bi-envelope-fill me-2"></i>Hubungi Saya
                    </a>
                    <a href="<?= base_url('/pendidikan'); ?>" class="btn btn-pink-outline btn-lg rounded-pill px-5 fw-bold">
                        <i class="bi bi-mortarboard me-2"></i>Perjalanan Saya
                    </a>
                </div>
            </div>
            <!-- Right Column: Profile Photo -->
            <div class="col-lg-6 d-flex justify-content-center position-relative">
                <div class="position-relative">
                    <?php
                    $nama = $biodata['nama'] ?? 'User';
                    $initials = '';
                    $words = explode(' ', trim($nama));
                    foreach ($words as $word) {
                        if (!empty($word)) {
                            $initials .= strtoupper(substr($word, 0, 1));
                        }
                    }
                    $initials = substr($initials, 0, 2);
                    if (empty($initials))
                        $initials = 'U';
                    ?>

                    <?php if (!empty($biodata['foto']) && file_exists(FCPATH . 'uploads/biodata/' . $biodata['foto'])): ?>
                        <img src="<?= base_url('uploads/biodata/' . $biodata['foto']); ?>" alt="<?= esc($nama); ?>"
                            class="img-fluid rounded shadow-lg"
                            style="max-width: 400px; object-fit: cover; border: 4px solid white;">
                    <?php else: ?>
                        <div class="rounded shadow-lg d-flex align-items-center justify-content-center text-white fw-bold p-5"
                            style="background: linear-gradient(135deg, #ec4899, #f472b6); width: 350px; height: 350px; font-size: 6rem; letter-spacing: 3px; border: 4px solid white;">
                            <?= esc($initials); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Section -->
    <div class="row g-4 mt-5 reveal">
        <div class="col-md-4">
            <div class="stat-card-pink text-center">
                <i class="bi bi-person-check-fill fs-1 mb-3"></i>
                <h3 class="fw-bold">Biodata</h3>
                <p class="mb-0 opacity-75">Informasi lengkap tentang diri saya</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card-pink text-center">
                <i class="bi bi-mortarboard-fill fs-1 mb-3"></i>
                <h3 class="fw-bold">Pendidikan</h3>
                <p class="mb-0 opacity-75">Riwayat pendidikan formal</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card-pink text-center">
                <i class="bi bi-activity fs-1 mb-3"></i>
                <h3 class="fw-bold">Aktivitas</h3>
                <p class="mb-0 opacity-75">Kegiatan dan pencapaian harian</p>
            </div>
        </div>
    </div>

    <!-- Contact Grid -->
    <div id="contact" class="mt-5">
        <div class="text-center mb-5">
            <h2 class="text-gradient-pink fw-bold">Informasi Kontak</h2>
            <p class="text-muted">Jangan ragu untuk menghubungi saya</p>
        </div>

        <div class="row g-4 reveal">
            <div class="col-md-4">
                <div class="card card-pink-glow border-0 rounded-4 h-100 p-4 hover-card">
                    <div class="text-center">
                        <div class="icon-box-modern mx-auto mb-3" style="width: 70px; height: 70px; font-size: 1.8rem;">
                            <i class="bi bi-envelope-fill"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-2">Email</h5>
                        <p class="text-muted small mb-3">Kirim pesan melalui email</p>
                        <h6 class="fw-bold text-break"><?= esc($biodata['email']); ?></h6>
                        <a href="mailto:<?= esc($biodata['email']); ?>" class="btn btn-pink-outline btn-sm mt-2">
                            <i class="bi bi-send me-1"></i>Kirim Email
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card card-pink-glow border-0 rounded-4 h-100 p-4 hover-card">
                    <div class="text-center">
                        <div class="icon-box-modern mx-auto mb-3" style="width: 70px; height: 70px; font-size: 1.8rem;">
                            <i class="bi bi-telephone-fill"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-2">Telepon</h5>
                        <p class="text-muted small mb-3">Hubungi langsung via telepon</p>
                        <h6 class="fw-bold"><?= esc($biodata['no_hp']); ?></h6>
                        <a href="tel:<?= esc($biodata['no_hp']); ?>" class="btn btn-pink-outline btn-sm mt-2">
                            <i class="bi bi-telephone me-1"></i>Telepon
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card card-pink-glow border-0 rounded-4 h-100 p-4 hover-card">
                    <div class="text-center">
                        <div class="icon-box-modern mx-auto mb-3" style="width: 70px; height: 70px; font-size: 1.8rem;">
                            <i class="bi bi-geo-alt-fill"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-2">Lokasi</h5>
                        <p class="text-muted small mb-3">Alamat tempat tinggal</p>
                        <h6 class="fw-bold"><?= esc($biodata['alamat']); ?></h6>
                        <button class="btn btn-pink-outline btn-sm mt-2" onclick="alert('Fitur peta akan segera hadir!')">
                            <i class="bi bi-map me-1"></i>Lihat Peta
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card card-pink-glow border-0 rounded-4 h-100 p-4 hover-card">
                    <div class="text-center">
                        <div class="icon-box-modern mx-auto mb-3" style="width: 70px; height: 70px; font-size: 1.8rem;">
                            <i class="bi bi-calendar-heart-fill"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-2">Tanggal Lahir</h5>
                        <p class="text-muted small mb-3">Hari spesial</p>
                        <h6 class="fw-bold">
                            <?php
                            if (!empty($biodata['tanggal_lahir'])) {
                                echo date('d F Y', strtotime($biodata['tanggal_lahir']));
                            } else {
                                echo '-';
                            }
                            ?>
                        </h6>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php else: ?>
    <div class="text-center py-5 fade-in-up">
        <div class="stat-card-pink mx-auto mb-4" style="width: 200px; padding: 2rem;">
            <i class="bi bi-person-x-fill fs-1 mb-3"></i>
            <h4 class="fw-bold">Biodata Tidak Ditemukan</h4>
        </div>
        <h3 class="text-gradient-pink fw-bold mb-3">Profil Belum Tersedia</h3>
        <p class="text-muted mb-4">Silakan konfigurasi biodata Anda melalui panel admin.</p>
        <a href="<?= base_url('/login'); ?>" class="btn btn-pink-gradient rounded-pill px-5 py-3">
            <i class="bi bi-gear-fill me-2"></i>Ke Panel Admin
        </a>
    </div>
<?php endif; ?>

<?= $this->endSection(); ?>