<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $title ?? 'Admin Panel'; ?></title>
    <link rel="icon" href="https://fav.farm/🛡️" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="<?= base_url('css/style.css'); ?>" rel="stylesheet">
    <style>
        :root {
            --sidebar-width: 260px;
            --sidebar-bg: #ffffff;
            --sidebar-link-color: #64748b;
            --sidebar-link-hover-bg: #FFFBEB;
            --sidebar-link-active-bg: #F59E0B;
            --content-bg: #f8fafc;
            --primary-color: #F59E0B;
            --text-dark: #1e293b;
        }
        body {
            background-color: var(--content-bg) !important;
            background-image: none !important;
            padding-top: 0 !important;
            font-family: 'Plus Jakarta Sans', sans-serif;
        }
        .wrapper {
            display: flex;
            width: 100%;
        }
        #sidebar {
            width: var(--sidebar-width);
            min-height: 100vh;
            background: var(--sidebar-bg);
            color: var(--text-dark);
            transition: all 0.3s;
            position: fixed;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }
        .sidebar-header {
            padding: 1.5rem 1.25rem;
            text-align: center;
            border-bottom: 1px solid #e2e8f0;
        }
        .admin-brand {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary-color);
            text-decoration: none;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.75rem;
        }
        .sidebar-nav {
            padding: 1rem 0;
            list-style: none;
            margin: 0;
            flex-grow: 1;
        }
        .sidebar-item {
            padding: 0 1rem;
        }
        .sidebar-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.85rem 1.25rem;
            color: var(--sidebar-link-color);
            text-decoration: none;
            border-radius: 0.5rem;
            font-weight: 500;
            transition: background-color 0.2s, color 0.2s;
        }
        .sidebar-link:hover {
            background-color: var(--sidebar-link-hover-bg);
            color: var(--primary-color);
        }
        .sidebar-link.active {
            background-color: var(--sidebar-link-active-bg);
            color: #fff;
            font-weight: 600;
        }
        .sidebar-link i {
            font-size: 1.2rem;
        }
        .sidebar-footer {
            padding: 1rem;
            border-top: 1px solid #e2e8f0;
        }
        #content {
            width: calc(100% - var(--sidebar-width));
            margin-left: var(--sidebar-width);
            padding: 2rem;
            transition: all 0.3s;
        }
        .mobile-header {
            display: none;
            padding: 0.5rem 1rem;
            background: #fff;
            border-bottom: 1px solid #eee;
        }
        
        @media (max-width: 768px) {
            #sidebar {
                margin-left: calc(-1 * var(--sidebar-width));
            }
            #sidebar.active {
                margin-left: 0;
            }
            #content {
                width: 100%;
                margin-left: 0;
            }
            .mobile-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
        }
        
        /* Bootstrap Overrides for Sunny Yellow Theme */
        .text-primary {
            color: var(--primary-color) !important;
        }
        .bg-primary {
            background-color: var(--primary-color) !important;
        }
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: #fff;
        }
        .btn-primary:hover {
            background-color: #D97706; /* Darker Amber */
            border-color: #D97706;
        }
        .page-title {
            color: var(--text-dark);
            font-weight: 800;
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <!-- Sidebar -->
        <nav id="sidebar">
            <?= $this->include('layout/sidebar'); ?>
        </nav>

        <!-- Page Content -->
        <div id="content">
            <header class="mobile-header">
                <a class="admin-brand text-dark" href="#">
                  <i class="bi bi-shield-shaded"></i>
                  <span>Admin Panel</span>
                </a>
                <button type="button" id="sidebarCollapse" class="btn btn-light border">
                    <i class="bi bi-list"></i>
                </button>
            </header>

            <main class="container-fluid">
                <?php if(session()->getFlashdata('message')) : ?>
                    <div class="alert alert-success border-0 shadow-sm rounded-4 mb-4 d-flex align-items-center" role="alert">
                        <i class="bi bi-check-circle-fill me-2 fs-4"></i>
                        <div><?= session()->getFlashdata('message'); ?></div>
                    </div>
                <?php endif; ?>

                <?php if(session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger border-0 shadow-sm rounded-4 mb-4 d-flex align-items-center" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2 fs-4"></i>
                        <div><?= session()->getFlashdata('error'); ?></div>
                    </div>
                <?php endif; ?>

                <?php if(session()->getFlashdata('errors')) : ?>
                    <div class="alert alert-danger border-0 shadow-sm rounded-4 mb-4" role="alert">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill me-2 fs-4"></i>
                            <div class="fw-bold">Validation Errors</div>
                        </div>
                        <ul class="mb-0 ps-3">
                            <?php foreach(session()->getFlashdata('errors') as $error) : ?>
                                <li><?= esc($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?= $this->renderSection('content'); ?>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const sidebarCollapse = document.getElementById('sidebarCollapse');
            const sidebar = document.getElementById('sidebar');

            if (sidebarCollapse) {
                sidebarCollapse.addEventListener('click', function () {
                    sidebar.classList.toggle('active');
                });
            }
        });
    </script>
</body>
</html>
