<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;

class Aktivitas extends BaseController
{
    protected $aktivitasModel;

    public function __construct()
    {
        $this->aktivitasModel = new AktivitasModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Daftar Aktivitas',
            'aktivitas' => $this->aktivitasModel->findAll()
        ];
        return view('admin/aktivitas/index', $data);
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Aktivitas',
            'validation' => \Config\Services::validation()
        ];
        return view('admin/aktivitas/create', $data);
    }

    public function save()
    {
        // Debug: Log incoming data
        if (ENVIRONMENT === 'development') {
            log_message('debug', 'Aktivitas save attempt - POST data: ' . json_encode($this->request->getPost()));
        }

        // Validate input
        if (!$this->validate($this->aktivitasModel->validationRules)) {
            $validation = \Config\Services::validation();
            $errors = $validation->getErrors();
            
            // Debug: Log validation errors
            if (ENVIRONMENT === 'development') {
                log_message('debug', 'Validation failed: ' . json_encode($errors));
            }
            
            // Set flash data for validation errors
            session()->setFlashdata('errors', $errors);
            session()->setFlashdata('error', 'Gagal menyimpan data. Periksa kembali form Anda.');
            
            return redirect()->to('/admin/aktivitas/create')->withInput();
        }

        try {
            // Prepare data
            // If keterangan is empty, ensure it's null if needed, or empty string
            // DB allows NULL now.
            $data = [
                'tanggal' => $this->request->getVar('tanggal'),
                'nama_aktivitas' => $this->request->getVar('nama_aktivitas'),
                'keterangan' => $this->request->getVar('keterangan') ?: null,
            ];
            
            // Debug: Log data to be saved
            if (ENVIRONMENT === 'development') {
                log_message('debug', 'Attempting to save aktivitas: ' . json_encode($data));
            }
            
            // Save to database
            $result = $this->aktivitasModel->save($data);
            
            if (!$result) {
                // Debug: Log save failure
                if (ENVIRONMENT === 'development') {
                    log_message('error', 'Model save returned false');
                }
                
                session()->setFlashdata('error', 'Gagal menyimpan data aktivitas. Silakan coba lagi.');
                return redirect()->to('/admin/aktivitas/create')->withInput();
            }
            
            // Debug: Log success
            if (ENVIRONMENT === 'development') {
                log_message('debug', 'Aktivitas saved successfully');
            }
            
            session()->setFlashdata('message', 'Data aktivitas berhasil ditambahkan.');
            return redirect()->to('/admin/aktivitas');
            
        } catch (\Exception $e) {
            // Debug: Log exception
            if (ENVIRONMENT === 'development') {
                log_message('error', 'Exception in aktivitas save: ' . $e->getMessage());
                log_message('error', 'Stack trace: ' . $e->getTraceAsString());
            }
            
            session()->setFlashdata('error', 'Terjadi kesalahan: ' . $e->getMessage());
            return redirect()->to('/admin/aktivitas/create')->withInput();
        }
    }

    public function edit($id)
    {
        $data = [
            'title' => 'Edit Aktivitas',
            'validation' => \Config\Services::validation(),
            'aktivitas' => $this->aktivitasModel->find($id)
        ];
        return view('admin/aktivitas/edit', $data);
    }

    public function update($id)
    {
        if (!$this->validate($this->aktivitasModel->validationRules)) {
            return redirect()->to('/admin/aktivitas/edit/' . $id)->withInput();
        }

        $this->aktivitasModel->save([
            'id' => $id,
            'tanggal' => $this->request->getVar('tanggal'),
            'nama_aktivitas' => $this->request->getVar('nama_aktivitas'),
            'keterangan' => $this->request->getVar('keterangan'),
        ]);

        session()->setFlashdata('message', 'Data aktivitas berhasil diubah.');
        return redirect()->to('/admin/aktivitas');
    }

    public function delete($id)
    {
        $this->aktivitasModel->delete($id);
        session()->setFlashdata('message', 'Data aktivitas berhasil dihapus.');
        return redirect()->to('/admin/aktivitas');
    }
}
