<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use App\Models\Produk;

class ProdukSearchTest extends TestCase
{
    use RefreshDatabase;

    /** @test */
    public function it_filters_products_by_query_and_stock_range()
    {
        // buat data produk
        Produk::create(['nama' => 'Laptop Asus ROG', 'stok' => 10]);
        Produk::create(['nama' => 'Mouse Gaming', 'stok' => 25]);
        Produk::create(['nama' => 'Keyboard Mechanical', 'stok' => 15]);

        // Pencarian kata 'Mouse' harus menampilkan Mouse Gaming
        $response = $this->get('/produk?q=Mouse');
        $response->assertStatus(200);
        $response->assertSee('Mouse Gaming');
        $response->assertDontSee('Laptop Asus ROG');

        // Filter stok: min 12, max 20 -> hanya Keyboard Mechanical (15)
        $response = $this->get('/produk?min_stok=12&max_stok=20');
        $response->assertStatus(200);
        $response->assertSee('Keyboard Mechanical');
        $response->assertDontSee('Mouse Gaming');

        // Kombinasi q dan stok
        $response = $this->get('/produk?q=Keyboard&min_stok=10&max_stok=16');
        $response->assertStatus(200);
        $response->assertSee('Keyboard Mechanical');
        $response->assertDontSee('Mouse Gaming');
    }
}
