<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ProdukController;
use App\Http\Controllers\TransaksiController;
use App\Http\Controllers\LaporanController;
use App\Http\Controllers\AuthController;
use Illuminate\Http\Request;
// Removed email verification routes to revert to pre-verification behavior

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('login');
});

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);

// Email verification routes removed to revert to pre-verification behavior

// Protect application routes with auth (verification disabled)
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::resource('produk', ProdukController::class);
    
    // Transaksi routes
    Route::get('barang-masuk', [TransaksiController::class, 'barangMasuk'])->name('barang.masuk');
    Route::post('barang-masuk', [TransaksiController::class, 'storeBarangMasuk']);
    Route::get('barang-keluar', [TransaksiController::class, 'barangKeluar'])->name('barang.keluar');
    Route::post('barang-keluar', [TransaksiController::class, 'storeBarangKeluar']);
    Route::get('riwayat-transaksi', [TransaksiController::class, 'riwayatTransaksi'])->name('riwayat.transaksi');
    
    // Laporan routes
    Route::get('laporan', [LaporanController::class, 'index'])->name('laporan');
    Route::get('laporan/export-pdf', [LaporanController::class, 'exportPdf'])->name('laporan.exportPdf');
    Route::get('laporan/export-excel', [LaporanController::class, 'exportExcel'])->name('laporan.exportExcel');
    
    // Logout route
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});
