<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Produk - Sistem Manajemen Gudang</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background: #f4f6fa; }
        .sidebar {
            min-height: 100vh;
            background: #2563eb;
            color: #fff;
            padding: 32px 18px 18px 18px;
        }
        .sidebar .nav-link {
            color: #fff;
            font-weight: 500;
            margin-bottom: 12px;
            border-radius: 8px;
            transition: background 0.2s;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            background: #1e40af;
            color: #fff;
        }
        .main-content {
            padding: 32px 24px;
        }
        .table-card {
            border-radius: 16px;
            box-shadow: 0 2px 12px rgba(31,38,135,0.08);
            background: #fff;
            padding: 24px;
        }
        .search-bar {
            margin-bottom: 18px;
        }
        .produk-thumb {
            width: 48px;
            height: 48px;
            object-fit: cover;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
        }
        .logo-sekai {
            max-width: 120px;
            height: auto;
            margin-bottom: 1rem;
        }
        .company-name {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        .system-name {
            font-size: 0.8rem;
            opacity: 0.8;
            margin-bottom: 1rem;
        }
        @media (max-width: 768px) {
            .sidebar { min-height: auto; padding: 16px 8px; }
            .main-content { padding: 16px 4px; }
            .table-card { padding: 8px; }
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block sidebar">
            <div class="position-sticky">
                <!-- Logo Section -->
                <div class="text-center mb-4">
                    <img src="{{ asset('images/logo-sekai.png') }}" alt="Logo Sekai" class="logo-sekai">
                    <div class="company-name">SEKAI</div>
                    <div class="system-name">Warehouse Management</div>
                </div>
                
                <h4 class="mb-4 fw-bold">Menu</h4>
                <ul class="nav flex-column">
                    <li class="nav-item"><a href="{{ route('dashboard') }}" class="nav-link"><i class="fa fa-home me-2"></i>Dashboard</a></li>
                    <li class="nav-item"><a href="{{ route('produk.index') }}" class="nav-link active"><i class="fa fa-box me-2"></i>Manajemen Produk</a></li>
                    <li class="nav-item"><a href="{{ route('barang.masuk') }}" class="nav-link"><i class="fa fa-arrow-down me-2"></i>Barang Masuk</a></li>
                    <li class="nav-item"><a href="{{ route('barang.keluar') }}" class="nav-link"><i class="fa fa-arrow-up me-2"></i>Barang Keluar</a></li>
                    <li class="nav-item"><a href="{{ route('riwayat.transaksi') }}" class="nav-link"><i class="fa fa-history me-2"></i>Riwayat Transaksi</a></li>
                    <li class="nav-item"><a href="{{ route('laporan') }}" class="nav-link"><i class="fa fa-file-alt me-2"></i>Laporan & Export</a></li>
                </ul>
                
                <!-- Logout Button -->
                <div class="mt-4 pt-3 border-top">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="btn btn-outline-light w-100">
                            <i class="fa fa-sign-out-alt me-2"></i>Logout
                        </button>
                    </form>
                </div>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 main-content">
            <div class="table-card">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="fw-bold mb-0">Manajemen Produk</h3>
                    <a href="{{ route('produk.create') }}" class="btn btn-primary">
                        <i class="fa fa-plus me-2"></i>Tambah Produk
                    </a>
                </div>
                
                <!-- Filter/Pencarian -->
                <form class="row g-2 align-items-center search-bar" method="GET" action="">
                    <div class="col-auto">
                        <input type="text" class="form-control" name="q" placeholder="Cari produk..." value="{{ request('q') }}">
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i> Cari</button>
                    </div>
                </form>
                
                <!-- Tabel Produk -->
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>Foto</th>
                                <th>Nama Produk</th>
                                <th>Stok</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($produk as $item)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        @if($item->foto)
                                            <img src="{{ asset('storage/' . $item->foto) }}" class="produk-thumb" alt="Foto Produk">
                                        @else
                                            <img src="https://via.placeholder.com/48x48?text=Foto" class="produk-thumb" alt="Foto Produk">
                                        @endif
                                    </td>
                                    <td>{{ $item->nama }}</td>
                                    <td>
                                        <span class="badge bg-{{ $item->stok > 10 ? 'success' : ($item->stok > 5 ? 'warning' : 'danger') }}">
                                            {{ $item->stok }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($item->stok > 10)
                                            <span class="badge bg-success">Tersedia</span>
                                        @elseif($item->stok > 5)
                                            <span class="badge bg-warning">Stok Menipis</span>
                                        @else
                                            <span class="badge bg-danger">Hampir Habis</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('produk.show', $item->id) }}" class="btn btn-sm btn-outline-info">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <a href="{{ route('produk.edit', $item->id) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <form action="{{ route('produk.destroy', $item->id) }}" method="POST" class="d-inline" 
                                              onsubmit="return confirm('Apakah Anda yakin ingin menghapus produk ini?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted">
                                        <i class="fa fa-inbox fa-3x mb-3"></i>
                                        <p>Belum ada data produk.</p>
                                        <a href="{{ route('produk.create') }}" class="btn btn-primary">
                                            <i class="fa fa-plus me-2"></i>Tambah Produk Pertama
                                        </a>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($produk->hasPages())
                    <div class="d-flex justify-content-center">
                        {{ $produk->links() }}
                    </div>
                @endif
            </div>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 