<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Produk;
use App\Models\Transaksi;
use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;

class LaporanController extends Controller
{
    public function index()
    {
        $totalProduk = Produk::count();
        $totalStok = Produk::sum('stok');
        $totalTransaksi = Transaksi::count();
        // Protect against missing columns in DB (migration may not have been applied fully)
        if (Schema::hasColumn('transaksis', 'tanggal')) {
            $transaksiHariIni = Transaksi::whereDate('tanggal', today())->count();
        } else {
            // fallback to created_at when tanggal column is missing
            $transaksiHariIni = Transaksi::whereDate('created_at', today())->count();
        }
    // Note: produk dengan stok terendah tidak ditampilkan di laporan/export sesuai permintaan.
        
        // Data untuk grafik (dummy data)
        $transaksiBulanan = [
            'Jan' => 45,
            'Feb' => 52,
            'Mar' => 38,
            'Apr' => 67,
            'Mei' => 73,
            'Jun' => 58
        ];
        
    // NOTE: produk dengan stok terendah tidak akan ditampilkan di laporan/export sesuai permintaan.
        
        // Transaksi terbaru
        $transaksiTerbaruQuery = Transaksi::with(['produk', 'user']);
        if (Schema::hasColumn('transaksis', 'tanggal')) {
            $transaksiTerbaruQuery = $transaksiTerbaruQuery->orderBy('tanggal', 'desc');
        } else {
            $transaksiTerbaruQuery = $transaksiTerbaruQuery->orderBy('created_at', 'desc');
        }
        $transaksiTerbaru = $transaksiTerbaruQuery->take(10)->get();
        
        return view('laporan', compact(
            'totalProduk',
            'totalStok', 
            'totalTransaksi',
            'transaksiHariIni',
            'transaksiBulanan',
            'transaksiTerbaru'
        ));
    }
    
    public function exportPdf()
    {
        // Export PDF - when implemented, exports will exclude products with stok <= 5
        return redirect()->back()->with('info', 'Fitur export PDF akan segera tersedia! (Produk dengan stok terendah akan dikecualikan)');
    }
    
    public function exportExcel()
    {
        // Export Excel - when implemented, exports will exclude products with stok <= 5
        return redirect()->back()->with('info', 'Fitur export Excel akan segera tersedia! (Produk dengan stok terendah akan dikecualikan)');
    }
}
