<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class EmailAuthController extends Controller
{
    public function sendOtp(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ]);

        $email = $request->input('email');
        $otp = rand(100000, 999999); // Generate OTP

        // Simpan OTP ke sesi atau database
        session(['otp' => $otp]);

        // Kirim email
        Mail::raw("Kode OTP Anda adalah: $otp", function ($message) use ($email) {
            $message->to($email)
                    ->subject('Kode OTP Anda');
        });

        return response()->json(['message' => 'OTP dikirim ke email Anda.']);
    }

    public function verifyOtp(Request $request)
    {
        $request->validate([
            'otp' => 'required|numeric',
        ]);

        $inputOtp = $request->input('otp');
        $sessionOtp = session('otp');

        if ($inputOtp == $sessionOtp) {
            // Autentikasi berhasil
            return response()->json(['message' => 'Autentikasi berhasil.']);
        }

        return response()->json(['message' => 'Kode OTP salah.'], 401);
    }
}
