<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('content') ?>
<div class="min-h-screen py-12 bg-sky-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-12 animate-fade-in">
            <span class="inline-block px-4 py-2 bg-purple-100 text-purple-600 rounded-full text-sm font-medium mb-4">
                <i class="fas fa-graduation-cap mr-2"></i>Pendidikan
            </span>
            <h1 class="text-3xl md:text-4xl font-bold mb-4 text-slate-800">Riwayat Pendidikan</h1>
            <p class="text-slate-500 max-w-2xl mx-auto">Perjalanan pendidikan saya dari SD hingga Perguruan Tinggi</p>
        </div>

        <!-- Filters -->
        <div class="bg-white border border-sky-100 rounded-2xl p-6 mb-8 animate-fade-in shadow-sm">
            <form action="<?= base_url('pendidikan') ?>" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="md:col-span-2">
                    <label class="block text-sm text-slate-500 mb-2">Pencarian <span class="text-xs">(min. 3 karakter)</span></label>
                    <input type="text" name="search" value="<?= esc($search ?? '') ?>" placeholder="Cari nama sekolah (min 3 huruf)..." minlength="3" class="w-full px-4 py-3 bg-sky-50 border border-sky-200 rounded-lg text-slate-800 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-purple-500">
                </div>
                <div>
                    <label class="block text-sm text-slate-500 mb-2">Jenjang</label>
                    <select name="jenjang" class="w-full px-4 py-3 bg-sky-50 border border-sky-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <option value="">Semua</option>
                        <?php foreach ($jenjangOptions as $opt): ?>
                            <option value="<?= $opt ?>" <?= ($jenjang ?? '') == $opt ? 'selected' : '' ?>><?= $opt ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="flex items-end gap-2">
                    <button type="submit" class="px-6 py-3 rounded-lg text-white w-full bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 shadow-lg shadow-purple-500/20">Filter</button>
                    <a href="<?= base_url('pendidikan') ?>" class="px-4 py-3 bg-slate-100 hover:bg-slate-200 rounded-lg text-slate-600"><i class="fas fa-times"></i></a>
                </div>
            </form>
        </div>

        <?php if (!empty($pendidikan)): ?>
            <!-- Timeline View -->
            <div class="max-w-3xl mx-auto">
                <div class="timeline pl-8 md:pl-12">
                    <?php foreach ($pendidikan as $index => $edu): ?>
                        <?php 
                        $colors = [
                            'SD' => ['bg' => 'bg-green-500', 'border' => 'border-green-500', 'text' => 'text-green-600', 'light' => 'bg-green-50'],
                            'SMP' => ['bg' => 'bg-blue-500', 'border' => 'border-blue-500', 'text' => 'text-blue-600', 'light' => 'bg-blue-50'],
                            'SMA' => ['bg' => 'bg-yellow-500', 'border' => 'border-yellow-500', 'text' => 'text-yellow-600', 'light' => 'bg-yellow-50'],
                            'Kuliah' => ['bg' => 'bg-purple-500', 'border' => 'border-purple-500', 'text' => 'text-purple-600', 'light' => 'bg-purple-50'],
                        ];
                        $color = $colors[$edu['jenjang']] ?? ['bg' => 'bg-slate-500', 'border' => 'border-slate-500', 'text' => 'text-slate-600', 'light' => 'bg-slate-50'];
                        ?>
                        <div class="timeline-item mb-8 animate-fade-in-up" style="animation-delay: <?= $index * 100 ?>ms">
                            <div class="card-hover <?= $color['light'] ?> border <?= $color['border'] ?>/20 rounded-2xl p-6 shadow-sm">
                                <div class="flex items-start justify-between mb-4">
                                    <span class="<?= $color['bg'] ?> text-white px-4 py-1 rounded-full text-sm font-semibold shadow-md">
                                        <?= $edu['jenjang'] ?>
                                    </span>
                                    <span class="text-slate-500 text-sm font-medium">
                                        <?= $edu['tahun_masuk'] ?> - <?= $edu['tahun_lulus'] ?? 'Sekarang' ?>
                                    </span>
                                </div>
                                <h3 class="text-xl font-bold text-slate-800 mb-2"><?= esc($edu['nama_sekolah']) ?></h3>
                                <div class="flex flex-wrap gap-3 text-sm">
                                    <?php if (!empty($edu['jurusan'])): ?>
                                        <span class="bg-white text-slate-600 px-3 py-1 rounded-full border border-slate-200">
                                            <i class="fas fa-book mr-1"></i><?= esc($edu['jurusan']) ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php if (!empty($edu['nilai_akhir'])): ?>
                                        <span class="bg-white text-slate-600 px-3 py-1 rounded-full border border-slate-200">
                                            <i class="fas fa-star mr-1 text-yellow-500"></i><?= esc($edu['nilai_akhir']) ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Pagination -->
            <?php if ($pager): ?>
                <div class="flex justify-center mt-8">
                    <?= $pager->links('default', 'tailwind_full') ?>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="text-center py-20 bg-white border border-sky-100 rounded-2xl shadow-sm">
                <div class="w-20 h-20 bg-sky-50 rounded-full flex items-center justify-center mx-auto mb-4 border border-sky-100">
                    <i class="fas fa-graduation-cap text-3xl text-sky-300"></i>
                </div>
                <h3 class="text-xl font-medium text-slate-800 mb-2">Tidak Ada Data Ditemukan</h3>
                <p class="text-slate-500">
                    <?php if ($search || $jenjang): ?>
                        Tidak ada riwayat pendidikan yang cocok dengan filter
                    <?php else: ?>
                        Belum ada riwayat pendidikan yang ditambahkan
                    <?php endif; ?>
                </p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>
