<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Portfolio Mahasiswa - Menampilkan aktivitas, biodata, dan riwayat pendidikan">
    <title><?= $title ?? 'Portfolio Mahasiswa' ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
</head>
<body class="bg-sky-50 text-slate-800 min-h-screen">
    <!-- Navbar -->
    <nav class="navbar-glass fixed top-0 left-0 right-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <!-- Logo -->
                <a href="<?= base_url('/') ?>" class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-sky-500 to-blue-600 rounded-lg flex items-center justify-center shadow-md">
                        <i class="fas fa-user-graduate text-white"></i>
                    </div>
                    <span class="text-xl font-bold bg-gradient-to-r from-sky-600 to-blue-600 bg-clip-text text-transparent">Portfolio</span>
                </a>

                <!-- Desktop Navigation -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="<?= base_url('/') ?>" class="nav-link text-slate-600 hover:text-sky-600 transition-colors <?= current_url() == base_url('/') ? 'active text-sky-600 font-semibold' : '' ?>">
                        <i class="fas fa-home mr-2"></i>Home
                    </a>
                    <a href="<?= base_url('aktivitas') ?>" class="nav-link text-slate-600 hover:text-sky-600 transition-colors <?= strpos(current_url(), '/aktivitas') !== false ? 'active text-sky-600 font-semibold' : '' ?>">
                        <i class="fas fa-calendar-day mr-2"></i>Aktivitas
                    </a>
                    <a href="<?= base_url('profile') ?>" class="nav-link text-slate-600 hover:text-sky-600 transition-colors <?= strpos(current_url(), '/profile') !== false ? 'active text-sky-600 font-semibold' : '' ?>">
                        <i class="fas fa-user mr-2"></i>Biodata
                    </a>
                    <a href="<?= base_url('pendidikan') ?>" class="nav-link text-slate-600 hover:text-sky-600 transition-colors <?= strpos(current_url(), '/pendidikan') !== false ? 'active text-sky-600 font-semibold' : '' ?>">
                        <i class="fas fa-graduation-cap mr-2"></i>Pendidikan
                    </a>
                </div>

                <!-- Admin Link -->
                <div class="hidden md:block">
                    <a href="<?= base_url('login') ?>" class="px-4 py-2 bg-gradient-to-r from-sky-500 to-blue-600 hover:from-sky-600 hover:to-blue-700 rounded-lg text-white text-sm font-medium transition-all shadow-md hover:shadow-lg">
                        <i class="fas fa-lock mr-2"></i>Admin
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <button onclick="toggleMobileNav()" class="md:hidden p-2 rounded-lg hover:bg-sky-100 text-slate-600 transition-colors">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
        </div>

        <!-- Mobile Navigation -->
        <div id="mobileNav" class="hidden md:hidden bg-white/95 backdrop-blur-lg border-t border-sky-100 shadow-lg">
            <div class="px-4 py-4 space-y-2">
                <a href="<?= base_url('/') ?>" class="block px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 transition-colors">
                    <i class="fas fa-home mr-3 w-5"></i>Home
                </a>
                <a href="<?= base_url('aktivitas') ?>" class="block px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 transition-colors">
                    <i class="fas fa-calendar-day mr-3 w-5"></i>Aktivitas
                </a>
                <a href="<?= base_url('profile') ?>" class="block px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 transition-colors">
                    <i class="fas fa-user mr-3 w-5"></i>Biodata
                </a>
                <a href="<?= base_url('pendidikan') ?>" class="block px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 transition-colors">
                    <i class="fas fa-graduation-cap mr-3 w-5"></i>Pendidikan
                </a>
                <div class="border-t border-sky-100 mt-4 pt-4">
                    <a href="<?= base_url('login') ?>" class="block px-4 py-3 rounded-lg text-sky-600 hover:text-sky-700 hover:bg-sky-50 transition-colors font-medium">
                        <i class="fas fa-lock mr-3 w-5"></i>Admin Login
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="pt-16">
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer class="bg-white border-t border-sky-100 mt-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- About -->
                <div>
                    <div class="flex items-center space-x-3 mb-4">
                        <div class="w-10 h-10 bg-gradient-to-br from-sky-500 to-blue-600 rounded-lg flex items-center justify-center shadow-sm">
                            <i class="fas fa-user-graduate text-white"></i>
                        </div>
                        <span class="text-xl font-bold text-slate-800">Portfolio Rohani</span>
                    </div>
                    <p class="text-slate-500 text-sm">Website portfolio yang menampilkan aktivitas harian, biodata, dan riwayat pendidikan.</p>
                </div>

                <!-- Quick Links -->
                <div>
                    <h3 class="text-lg font-semibold text-slate-800 mb-4">Quick Links</h3>
                    <ul class="space-y-2 text-sm">
                        <li><a href="<?= base_url('/') ?>" class="text-slate-500 hover:text-sky-600 transition-colors">Home</a></li>
                        <li><a href="<?= base_url('aktivitas') ?>" class="text-slate-500 hover:text-sky-600 transition-colors">Aktivitas Harian</a></li>
                        <li><a href="<?= base_url('profile') ?>" class="text-slate-500 hover:text-sky-600 transition-colors">Biodata / CV</a></li>
                        <li><a href="<?= base_url('pendidikan') ?>" class="text-slate-500 hover:text-sky-600 transition-colors">Riwayat Pendidikan</a></li>
                    </ul>
                </div>

                <!-- Social Media -->
                <div>
                    <h3 class="text-lg font-semibold text-slate-800 mb-4">Media Sosial</h3>
                    <div class="space-y-3">
                        <a href="https://www.instagram.com/ro_hni?igsh=NGlrbzhwZzJkNGE3" target="_blank" class="flex items-center text-slate-500 hover:text-pink-500 transition-colors">
                            <div class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-500 rounded-lg flex items-center justify-center mr-3 shadow-sm">
                                <i class="fab fa-instagram text-white"></i>
                            </div>
                            <span>@ro_hni</span>
                        </a>
                        <a href="https://wa.me/+6283811158668" target="_blank" class="flex items-center text-slate-500 hover:text-green-500 transition-colors">
                            <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-500 rounded-lg flex items-center justify-center mr-3 shadow-sm">
                                <i class="fab fa-whatsapp text-white"></i>
                            </div>
                            <span>+62 838-1115-8668</span>
                        </a>
                    </div>
                </div>
            </div>

            <div class="border-t border-sky-100 mt-8 pt-8 text-center text-slate-400 text-sm">
                <p>&copy; <?= date('Y') ?> Portfolio Rohani</p>
            </div>
        </div>
    </footer>

    <script src="<?= base_url('assets/js/app.js') ?>"></script>
</body>
</html>
