<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('content') ?>
<!-- Hero Section -->
<section class="hero-gradient hero-pattern min-h-screen flex items-center relative overflow-hidden">
    <!-- Background Animation -->
    <div class="absolute inset-0">
        <div class="absolute top-1/4 left-1/4 w-96 h-96 bg-sky-200/50 rounded-full blur-3xl animate-pulse"></div>
        <div class="absolute bottom-1/4 right-1/4 w-96 h-96 bg-blue-200/50 rounded-full blur-3xl animate-pulse delay-500"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 relative z-10">
        <div class="grid md:grid-cols-2 gap-12 items-center">
            <!-- Text Content -->
            <div class="animate-fade-in">
                <span class="inline-block px-4 py-2 bg-sky-100 text-sky-600 rounded-full text-sm font-medium mb-6">
                    <i class="fas fa-star mr-2"></i>Portfolio 
                </span>
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold leading-tight mb-6 text-slate-800">
                    <?php if (!empty($biodata)): ?>
                        Halo, Saya<br>
                        <span class="bg-gradient-to-r from-sky-500 via-blue-500 to-indigo-500 bg-clip-text text-transparent">
                            <?= esc($biodata['nama_lengkap']) ?>
                        </span>
                    <?php else: ?>
                        Selamat Datang di<br>
                        <span class="bg-gradient-to-r from-sky-500 via-blue-500 to-indigo-500 bg-clip-text text-transparent">
                            Portfolio Saya
                        </span>
                    <?php endif; ?>
                </h1>
                <p class="text-lg text-slate-500 mb-8 max-w-2xl">
                    <?php if (!empty($biodata['deskripsi_diri'])): ?>
                        <?= esc($biodata['deskripsi_diri']) ?>
                    <?php else: ?>
                        Website ini menampilkan aktivitas harian, biodata personal, dan riwayat pendidikan saya.
                    <?php endif; ?>
                </p>
                <div class="flex flex-wrap gap-4">
                    <a href="<?= base_url('profile') ?>" class="btn-primary px-8 py-4 rounded-xl text-white font-medium inline-flex items-center shadow-lg shadow-sky-500/30">
                        <i class="fas fa-user mr-2"></i>
                        Lihat Profile
                    </a>
                    <a href="<?= base_url('aktivitas') ?>" class="px-8 py-4 rounded-xl text-slate-600 font-medium inline-flex items-center border border-slate-200 hover:bg-slate-50 hover:text-sky-600 transition-colors">
                        <i class="fas fa-calendar mr-2"></i>
                        Aktivitas Saya
                    </a>
                </div>
            </div>

            <!-- Profile Image or Illustration -->
            <div class="animate-fade-in delay-200 flex justify-center md:justify-end">
                <?php if (!empty($biodata['foto'])): ?>
                    <div class="relative">
                        <div class="absolute -inset-4 bg-gradient-to-r from-sky-400 to-blue-500 rounded-2xl blur-xl opacity-20 animate-pulse"></div>
                        <img src="<?= base_url('assets/uploads/biodata/' . $biodata['foto']) ?>" 
                             alt="<?= esc($biodata['nama_lengkap']) ?>"
                             class="relative w-72 h-72 md:w-96 md:h-96 rounded-2xl object-cover border-4 border-white shadow-2xl shadow-sky-500/20">
                    </div>
                <?php else: ?>
                    <div class="relative">
                        <div class="absolute -inset-4 bg-gradient-to-r from-sky-400 to-blue-500 rounded-2xl blur-xl opacity-20 animate-pulse"></div>
                        <div class="relative w-72 h-72 md:w-96 md:h-96 rounded-2xl bg-gradient-to-br from-sky-100 to-blue-100 flex items-center justify-center border-4 border-white shadow-2xl shadow-sky-500/20">
                            <i class="fas fa-user text-8xl md:text-9xl text-sky-200"></i>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Scroll Indicator -->
    <div class="absolute bottom-8 left-1/2 -translate-x-1/2 animate-bounce">
        <a href="#aktivitas" class="text-slate-400 hover:text-sky-600 transition-colors">
            <i class="fas fa-chevron-down text-2xl"></i>
        </a>
    </div>
</section>

<!-- Recent Activities Section -->
<section id="aktivitas" class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12 animate-fade-in-up">
            <span class="inline-block px-4 py-2 bg-sky-100 text-sky-600 rounded-full text-sm font-medium mb-4">
                <i class="fas fa-clock mr-2"></i>Aktivitas Terbaru
            </span>
            <h2 class="text-3xl md:text-4xl font-bold mb-4 text-slate-800">Apa yang Saya Lakukan</h2>
            <p class="text-slate-500 max-w-2xl mx-auto">Berikut adalah beberapa aktivitas harian terbaru yang saya kerjakan</p>
        </div>

        <?php if (!empty($recentAktivitas)): ?>
            <div class="grid md:grid-cols-3 gap-6">
                <?php foreach ($recentAktivitas as $index => $item): ?>
                    <div class="card-hover bg-white border border-slate-100 rounded-2xl overflow-hidden animate-fade-in-up delay-<?= ($index + 1) * 100 ?> shadow-sm hover:shadow-xl hover:shadow-sky-500/10">
                        <?php if (!empty($item['foto'])): ?>
                            <img src="<?= base_url('assets/uploads/aktivitas/' . $item['foto']) ?>" 
                                 alt="<?= esc($item['nama_aktivitas']) ?>"
                                 class="w-full h-48 object-cover">
                        <?php else: ?>
                            <div class="w-full h-48 bg-gradient-to-br from-sky-50 to-blue-50 flex items-center justify-center">
                                <i class="fas fa-tasks text-4xl text-sky-200"></i>
                            </div>
                        <?php endif; ?>
                        <div class="p-6">
                            <div class="flex items-center text-sm text-slate-400 mb-3">
                                <i class="far fa-calendar mr-2"></i>
                                <?= date('d M Y', strtotime($item['tanggal'])) ?>
                                <span class="mx-2">•</span>
                                <i class="far fa-clock mr-2"></i>
                                <?= $item['jam'] ?>
                            </div>
                            <h3 class="text-lg font-semibold text-slate-800 mb-2"><?= esc($item['nama_aktivitas']) ?></h3>
                            <?php if (!empty($item['deskripsi'])): ?>
                                <p class="text-slate-500 text-sm line-clamp-2"><?= esc($item['deskripsi']) ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="text-center mt-10">
                <a href="<?= base_url('aktivitas') ?>" class="btn-primary px-8 py-4 rounded-xl text-white font-medium inline-flex items-center shadow-lg shadow-sky-500/30">
                    Lihat Semua Aktivitas
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
        <?php else: ?>
            <div class="text-center py-12 text-slate-400">
                <i class="fas fa-inbox text-5xl mb-4 text-slate-300"></i>
                <p>Belum ada aktivitas yang ditampilkan</p>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Quick Navigation Cards -->
<section class="py-20 bg-sky-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid md:grid-cols-3 gap-8">
            <!-- Profile Card -->
            <a href="<?= base_url('profile') ?>" class="card-hover group bg-white border border-sky-100 rounded-2xl p-8 text-center shadow-sm hover:shadow-xl hover:shadow-blue-500/10">
                <div class="w-16 h-16 bg-blue-50 rounded-xl flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform">
                    <i class="fas fa-id-card text-3xl text-blue-500"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-800 mb-2">Biodata / CV</h3>
                <p class="text-slate-500 text-sm">Lihat informasi personal dan CV lengkap saya</p>
            </a>

            <!-- Activities Card -->
            <a href="<?= base_url('aktivitas') ?>" class="card-hover group bg-white border border-emerald-100 rounded-2xl p-8 text-center shadow-sm hover:shadow-xl hover:shadow-emerald-500/10">
                <div class="w-16 h-16 bg-emerald-50 rounded-xl flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform">
                    <i class="fas fa-calendar-check text-3xl text-emerald-500"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-800 mb-2">Aktivitas Harian</h3>
                <p class="text-slate-500 text-sm">Jelajahi aktivitas dan kegiatan harian saya</p>
            </a>

            <!-- Education Card -->
            <a href="<?= base_url('pendidikan') ?>" class="card-hover group bg-white border border-purple-100 rounded-2xl p-8 text-center shadow-sm hover:shadow-xl hover:shadow-purple-500/10">
                <div class="w-16 h-16 bg-purple-50 rounded-xl flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform">
                    <i class="fas fa-graduation-cap text-3xl text-purple-500"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-800 mb-2">Riwayat Pendidikan</h3>
                <p class="text-slate-500 text-sm">Lihat perjalanan pendidikan dari SD hingga Kuliah</p>
            </a>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
