<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('content') ?>
<div class="min-h-screen py-12 bg-sky-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-12 animate-fade-in">
            <span class="inline-block px-4 py-2 bg-sky-100 text-sky-600 rounded-full text-sm font-medium mb-4">
                <i class="fas fa-calendar-check mr-2"></i>Aktivitas Harian
            </span>
            <h1 class="text-3xl md:text-4xl font-bold mb-4 text-slate-800">Aktivitas & Kegiatan Saya</h1>
            <p class="text-slate-500 max-w-2xl mx-auto">Daftar aktivitas harian lengkap dengan foto dan video dokumentasi</p>
        </div>

        <!-- Filters -->
        <div class="bg-white border border-sky-100 rounded-2xl p-6 mb-8 animate-fade-in shadow-sm">
            <form action="<?= base_url('aktivitas') ?>" method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                <!-- Search -->
                <div class="md:col-span-2">
                    <label class="block text-sm text-slate-500 mb-2">Pencarian <span class="text-xs">(min. 3 karakter)</span></label>
                    <div class="relative">
                        <input type="text" name="search" value="<?= esc($search ?? '') ?>" placeholder="Cari aktivitas (min 3 huruf)..." minlength="3" class="w-full px-4 py-3 pl-10 bg-sky-50 border border-sky-200 rounded-lg text-slate-800 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500">
                        <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                    </div>
                </div>

                <!-- Start Date -->
                <div>
                    <label class="block text-sm text-slate-500 mb-2">Dari Tanggal</label>
                    <input type="date" name="start_date" value="<?= esc($startDate ?? '') ?>" class="w-full px-4 py-3 bg-sky-50 border border-sky-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-sky-500">
                </div>

                <!-- End Date -->
                <div>
                    <label class="block text-sm text-slate-500 mb-2">Sampai Tanggal</label>
                    <input type="date" name="end_date" value="<?= esc($endDate ?? '') ?>" class="w-full px-4 py-3 bg-sky-50 border border-sky-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-sky-500">
                </div>

                <!-- Buttons -->
                <div class="flex items-end gap-2">
                    <button type="submit" class="btn-primary px-6 py-3 rounded-lg text-white w-full shadow-md shadow-sky-500/20">
                        <i class="fas fa-filter mr-2"></i>Filter
                    </button>
                    <a href="<?= base_url('aktivitas') ?>" class="px-4 py-3 bg-slate-100 hover:bg-slate-200 rounded-lg text-slate-600 transition-colors">
                        <i class="fas fa-times"></i>
                    </a>
                </div>
            </form>
        </div>

        <!-- Results Info -->
        <?php if (!empty($aktivitas)): ?>
            <div class="flex items-center justify-between mb-6 text-sm text-slate-500">
                <span>Menampilkan <?= count($aktivitas) ?> dari <?= $total ?> aktivitas</span>
                <!-- Sort Options -->
                <div class="flex items-center gap-2">
                    <span>Urutkan:</span>
                    <a href="<?= base_url('aktivitas') ?>?<?= http_build_query(array_merge($_GET, ['sort' => 'tanggal', 'order' => $sort == 'tanggal' && $order == 'DESC' ? 'ASC' : 'DESC'])) ?>" 
                       class="px-3 py-1 rounded <?= $sort == 'tanggal' ? 'bg-sky-100 text-sky-600' : 'bg-white border border-slate-200 text-slate-500' ?>">
                        Tanggal <?= $sort == 'tanggal' ? ($order == 'DESC' ? '↓' : '↑') : '' ?>
                    </a>
                    <a href="<?= base_url('aktivitas') ?>?<?= http_build_query(array_merge($_GET, ['sort' => 'nama_aktivitas', 'order' => $sort == 'nama_aktivitas' && $order == 'ASC' ? 'DESC' : 'ASC'])) ?>"
                       class="px-3 py-1 rounded <?= $sort == 'nama_aktivitas' ? 'bg-sky-100 text-sky-600' : 'bg-white border border-slate-200 text-slate-500' ?>">
                        Nama <?= $sort == 'nama_aktivitas' ? ($order == 'ASC' ? '↑' : '↓') : '' ?>
                    </a>
                </div>
            </div>

            <!-- Activity Cards Grid -->
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                <?php foreach ($aktivitas as $index => $item): ?>
                    <div class="card-hover bg-white border border-sky-100 rounded-2xl overflow-hidden animate-fade-in-up shadow-sm hover:shadow-lg" style="animation-delay: <?= $index * 50 ?>ms">
                        <!-- Media -->
                        <?php if (!empty($item['foto'])): ?>
                            <img src="<?= base_url('assets/uploads/aktivitas/' . $item['foto']) ?>" 
                                 alt="<?= esc($item['nama_aktivitas']) ?>"
                                 class="w-full h-48 object-cover">
                        <?php elseif (!empty($item['video'])): ?>
                            <video controls class="w-full h-48 object-cover bg-slate-100">
                                <source src="<?= base_url('assets/uploads/aktivitas/' . $item['video']) ?>" type="video/mp4">
                            </video>
                        <?php else: ?>
                            <div class="w-full h-48 bg-gradient-to-br from-sky-50 to-blue-50 flex items-center justify-center">
                                <i class="fas fa-tasks text-4xl text-sky-200"></i>
                            </div>
                        <?php endif; ?>

                        <!-- Content -->
                        <div class="p-6">
                            <div class="flex items-center text-sm text-slate-400 mb-3">
                                <span class="bg-sky-100 text-sky-600 px-2 py-1 rounded text-xs mr-2">
                                    <i class="far fa-calendar mr-1"></i><?= date('d M Y', strtotime($item['tanggal'])) ?>
                                </span>
                                <span class="bg-emerald-100 text-emerald-600 px-2 py-1 rounded text-xs">
                                    <i class="far fa-clock mr-1"></i><?= $item['jam'] ?>
                                </span>
                            </div>
                            <h3 class="text-lg font-semibold text-slate-800 mb-2"><?= esc($item['nama_aktivitas']) ?></h3>
                            <?php if (!empty($item['deskripsi'])): ?>
                                <p class="text-slate-500 text-sm line-clamp-3"><?= esc($item['deskripsi']) ?></p>
                            <?php endif; ?>
                            
                            <!-- Media Badges -->
                            <div class="flex items-center gap-2 mt-4">
                                <?php if (!empty($item['foto'])): ?>
                                    <span class="bg-emerald-50 text-emerald-600 px-2 py-1 rounded text-xs border border-emerald-100">
                                        <i class="fas fa-image mr-1"></i>Foto
                                    </span>
                                <?php endif; ?>
                                <?php if (!empty($item['video'])): ?>
                                    <span class="bg-purple-50 text-purple-600 px-2 py-1 rounded text-xs border border-purple-100">
                                        <i class="fas fa-video mr-1"></i>Video
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Pagination -->
            <?php if ($pager): ?>
                <div class="flex justify-center">
                    <?= $pager->links('default', 'tailwind_full') ?>
                </div>
            <?php endif; ?>

        <?php else: ?>
            <div class="text-center py-20 bg-white border border-sky-100 rounded-2xl shadow-sm">
                <div class="w-20 h-20 bg-sky-50 rounded-full flex items-center justify-center mx-auto mb-4 border border-sky-100">
                    <i class="fas fa-search text-3xl text-sky-300"></i>
                </div>
                <h3 class="text-xl font-medium text-slate-800 mb-2">Tidak Ada Aktivitas Ditemukan</h3>
                <p class="text-slate-500 mb-6">
                    <?php if ($search || $startDate || $endDate): ?>
                        Tidak ada aktivitas yang cocok dengan filter Anda
                    <?php else: ?>
                        Belum ada aktivitas yang ditambahkan
                    <?php endif; ?>
                </p>
                <?php if ($search || $startDate || $endDate): ?>
                    <a href="<?= base_url('aktivitas') ?>" class="btn-primary px-6 py-3 rounded-lg text-white inline-flex items-center shadow-lg shadow-sky-500/20">
                        <i class="fas fa-times mr-2"></i>Hapus Filter
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>
