<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in">
    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <!-- Total Aktivitas -->
        <div class="card-hover bg-white border border-blue-100 rounded-2xl p-6 shadow-sm hover:shadow-blue-500/10">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-500 text-sm mb-1">Total Aktivitas</p>
                    <h3 class="text-3xl font-bold text-slate-800"><?= $totalAktivitas ?? 0 ?></h3>
                </div>
                <div class="w-14 h-14 bg-blue-50 rounded-xl flex items-center justify-center">
                    <i class="fas fa-calendar-check text-2xl text-blue-500"></i>
                </div>
            </div>
            <a href="<?= base_url('admin/aktivitas') ?>" class="inline-flex items-center text-blue-600 text-sm mt-4 hover:text-blue-700 transition-colors">
                Lihat detail <i class="fas fa-arrow-right ml-2"></i>
            </a>
        </div>

        <!-- Total Biodata -->
        <div class="card-hover bg-white border border-emerald-100 rounded-2xl p-6 shadow-sm hover:shadow-emerald-500/10">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-500 text-sm mb-1">Biodata</p>
                    <h3 class="text-3xl font-bold text-slate-800"><?= $totalBiodata ?? 0 ?></h3>
                </div>
                <div class="w-14 h-14 bg-emerald-50 rounded-xl flex items-center justify-center">
                    <i class="fas fa-id-card text-2xl text-emerald-500"></i>
                </div>
            </div>
            <a href="<?= base_url('admin/biodata') ?>" class="inline-flex items-center text-emerald-600 text-sm mt-4 hover:text-emerald-700 transition-colors">
                Lihat detail <i class="fas fa-arrow-right ml-2"></i>
            </a>
        </div>

        <!-- Total Pendidikan -->
        <div class="card-hover bg-white border border-purple-100 rounded-2xl p-6 shadow-sm hover:shadow-purple-500/10">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-500 text-sm mb-1">Riwayat Pendidikan</p>
                    <h3 class="text-3xl font-bold text-slate-800"><?= $totalPendidikan ?? 0 ?></h3>
                </div>
                <div class="w-14 h-14 bg-purple-50 rounded-xl flex items-center justify-center">
                    <i class="fas fa-graduation-cap text-2xl text-purple-500"></i>
                </div>
            </div>
            <a href="<?= base_url('admin/pendidikan') ?>" class="inline-flex items-center text-purple-600 text-sm mt-4 hover:text-purple-700 transition-colors">
                Lihat detail <i class="fas fa-arrow-right ml-2"></i>
            </a>
        </div>
    </div>

    <!-- Recent Activities -->
    <div class="bg-white border border-slate-200 rounded-2xl overflow-hidden shadow-sm">
        <div class="px-6 py-4 border-b border-slate-100 flex items-center justify-between">
            <h2 class="text-lg font-semibold flex items-center text-slate-800">
                <i class="fas fa-clock text-blue-500 mr-2"></i>
                Aktivitas Terbaru
            </h2>
            <a href="<?= base_url('admin/aktivitas') ?>" class="text-sm text-blue-600 hover:text-blue-700 transition-colors">
                Lihat Semua
            </a>
        </div>
        
        <?php if (!empty($recentAktivitas)): ?>
            <div class="divide-y divide-slate-100">
                <?php foreach ($recentAktivitas as $aktivitas): ?>
                    <div class="px-6 py-4 hover:bg-slate-50 transition-colors">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-4">
                                <div class="w-10 h-10 bg-blue-50 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-tasks text-blue-500"></i>
                                </div>
                                <div>
                                    <h3 class="font-medium text-slate-800"><?= esc($aktivitas['nama_aktivitas']) ?></h3>
                                    <p class="text-sm text-slate-500">
                                        <i class="far fa-calendar mr-1"></i>
                                        <?= date('d M Y', strtotime($aktivitas['tanggal'])) ?>
                                        <span class="mx-2">•</span>
                                        <i class="far fa-clock mr-1"></i>
                                        <?= $aktivitas['jam'] ?>
                                    </p>
                                </div>
                            </div>
                            <a href="<?= base_url('admin/aktivitas/edit/' . $aktivitas['id']) ?>" class="text-blue-500 hover:text-blue-700 transition-colors">
                                <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="px-6 py-12 text-center text-slate-400">
                <i class="fas fa-inbox text-4xl mb-4 text-slate-300"></i>
                <p>Belum ada aktivitas</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Quick Actions -->
    <div class="mt-8 grid grid-cols-1 md:grid-cols-3 gap-4">
        <a href="<?= base_url('admin/aktivitas/create') ?>" class="btn-primary flex items-center justify-center py-4 px-6 rounded-xl text-white font-medium">
            <i class="fas fa-plus mr-2"></i>
            Tambah Aktivitas
        </a>
        <a href="<?= base_url('admin/biodata/create') ?>" class="btn-success flex items-center justify-center py-4 px-6 rounded-xl text-white font-medium">
            <i class="fas fa-user-plus mr-2"></i>
            Tambah Biodata
        </a>
        <a href="<?= base_url('admin/pendidikan/create') ?>" class="flex items-center justify-center py-4 px-6 rounded-xl text-white font-medium bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 transition-all duration-300 transform hover:-translate-y-1">
            <i class="fas fa-school mr-2"></i>
            Tambah Pendidikan
        </a>
    </div>
</div>
<?= $this->endSection() ?>
