<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in">
    <!-- Header Actions -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6 gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">Data Biodata / CV</h2>
            <p class="text-slate-500">Kelola data personal dan CV Anda</p>
        </div>
        <a href="<?= base_url('admin/biodata/create') ?>" class="btn-primary inline-flex items-center px-6 py-3 rounded-xl text-white font-medium shadow-lg shadow-sky-500/30">
            <i class="fas fa-plus mr-2"></i>
            Tambah Biodata
        </a>
    </div>

    <!-- Data Cards -->
    <?php if (!empty($biodata)): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <?php foreach ($biodata as $item): ?>
                <div class="card-hover bg-white border border-slate-200 rounded-2xl overflow-hidden shadow-sm hover:shadow-lg">
                    <div class="p-6">
                        <div class="flex items-start space-x-4">
                            <!-- Photo -->
                            <div class="flex-shrink-0 relative">
                                <?php if (!empty($item['foto'])): ?>
                                    <img src="<?= base_url('assets/uploads/biodata/' . $item['foto']) ?>" 
                                         alt="<?= esc($item['nama_lengkap']) ?>"
                                         class="w-20 h-20 rounded-xl object-cover border-2 <?= $item['is_active'] ? 'border-sky-500' : 'border-slate-100' ?> shadow-sm">
                                <?php else: ?>
                                    <div class="w-20 h-20 bg-gradient-to-br from-blue-100 to-sky-200 rounded-xl flex items-center justify-center border-2 border-white shadow-sm">
                                        <i class="fas fa-user text-3xl text-blue-500"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <!-- Active Badge -->
                                <?php if ($item['is_active']): ?>
                                    <div class="absolute -top-2 -right-2 w-6 h-6 bg-sky-500 rounded-full flex items-center justify-center border-2 border-white shadow-sm" title="Active CV">
                                        <i class="fas fa-check text-xs text-white"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Info -->
                            <div class="flex-1 min-w-0">
                                <h3 class="text-xl font-bold text-slate-800 mb-2 flex items-center gap-2">
                                    <?= esc($item['nama_lengkap']) ?>
                                    <?php if ($item['is_active']): ?>
                                        <span class="inline-block px-2 py-0.5 bg-sky-100 text-sky-600 text-xs rounded-full border border-sky-200">Aktif</span>
                                    <?php endif; ?>
                                </h3>
                                <div class="space-y-2 text-sm">
                                    <p class="text-slate-500 flex items-center">
                                        <i class="fas fa-envelope w-5 text-blue-500"></i>
                                        <?= esc($item['email']) ?>
                                    </p>
                                    <p class="text-slate-500 flex items-center">
                                        <i class="fas fa-phone w-5 text-green-500"></i>
                                        <?= esc($item['no_hp']) ?>
                                    </p>
                                    <?php if (!empty($item['jenis_kelamin'])): ?>
                                        <p class="text-slate-500 flex items-center">
                                            <i class="fas fa-venus-mars w-5 text-pink-500"></i>
                                            <?= esc($item['jenis_kelamin']) ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if (!empty($item['tempat_lahir']) || !empty($item['tanggal_lahir'])): ?>
                                        <p class="text-slate-500 flex items-center">
                                            <i class="fas fa-birthday-cake w-5 text-yellow-500"></i>
                                            <?php 
                                            $ttl = [];
                                            if (!empty($item['tempat_lahir'])) $ttl[] = esc($item['tempat_lahir']);
                                            if (!empty($item['tanggal_lahir'])) {
                                                $date = new DateTime($item['tanggal_lahir']);
                                                $ttl[] = $date->format('d M Y');
                                            }
                                            echo implode(', ', $ttl);
                                            ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if (!empty($item['agama'])): ?>
                                        <p class="text-slate-500 flex items-center">
                                            <i class="fas fa-pray w-5 text-purple-500"></i>
                                            <?= esc($item['agama']) ?>
                                        </p>
                                    <?php endif; ?>
                                    <p class="text-slate-500 flex items-start">
                                        <i class="fas fa-map-marker-alt w-5 text-red-500 mt-1"></i>
                                        <span class="truncate"><?= esc($item['alamat']) ?></span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <?php if (!empty($item['deskripsi_diri'])): ?>
                            <div class="mt-4 pt-4 border-t border-slate-100">
                                <p class="text-slate-500 text-sm line-clamp-3"><?= esc($item['deskripsi_diri']) ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Actions -->
                    <div class="px-6 py-4 bg-slate-50 flex items-center justify-end space-x-2 border-t border-slate-100">
                        <!-- Activate Toggle -->
                        <form action="<?= base_url('admin/biodata/activate/' . $item['id']) ?>" method="POST" class="inline">
                            <?= csrf_field() ?>
                            <button type="submit" 
                                    class="px-4 py-2 rounded-lg transition-colors inline-flex items-center <?= $item['is_active'] ? 'bg-sky-100 text-sky-600 cursor-default' : 'bg-white border border-slate-200 text-slate-500 hover:bg-sky-50 hover:text-sky-600 hover:border-sky-200' ?>" 
                                    <?= $item['is_active'] ? 'disabled' : '' ?>>
                                <i class="fas <?= $item['is_active'] ? 'fa-toggle-on' : 'fa-toggle-off' ?> mr-2"></i>
                                <?= $item['is_active'] ? 'Aktif' : 'Aktifkan' ?>
                            </button>
                        </form>

                        <a href="<?= base_url('admin/biodata/edit/' . $item['id']) ?>" 
                           class="px-4 py-2 bg-blue-100 text-blue-600 rounded-lg hover:bg-blue-200 transition-colors inline-flex items-center">
                            <i class="fas fa-edit mr-2"></i>
                            Edit
                        </a>
                        <form id="deleteForm<?= $item['id'] ?>" action="<?= base_url('admin/biodata/delete/' . $item['id']) ?>" method="POST" class="inline">
                            <?= csrf_field() ?>
                            <button type="button" 
                                    onclick="confirmDelete('deleteForm<?= $item['id'] ?>', '<?= esc($item['nama_lengkap']) ?>')" 
                                    class="px-4 py-2 bg-red-100 text-red-600 rounded-lg hover:bg-red-200 transition-colors inline-flex items-center">
                                    <i class="fas fa-trash mr-2"></i>
                                Hapus
                            </button>
                        </form>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="bg-white border border-slate-200 rounded-2xl px-6 py-16 text-center shadow-sm">
            <div class="w-20 h-20 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4 text-slate-400">
                <i class="fas fa-id-card text-3xl"></i>
            </div>
            <h3 class="text-xl font-medium text-slate-800 mb-2">Belum Ada Biodata</h3>
            <p class="text-slate-500 mb-6">Mulai tambahkan biodata/CV Anda</p>
            <a href="<?= base_url('admin/biodata/create') ?>" class="btn-primary inline-flex items-center px-6 py-3 rounded-xl text-white font-medium shadow-lg shadow-sky-500/30">
                <i class="fas fa-plus mr-2"></i>
                Tambah Biodata Pertama
            </a>
        </div>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>
