<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in">
    <!-- Header Actions -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6 gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">Data Aktivitas Harian</h2>
            <p class="text-slate-500">Kelola semua aktivitas harian Anda</p>
        </div>
        <a href="<?= base_url('admin/aktivitas/create') ?>" class="btn-primary inline-flex items-center px-6 py-3 rounded-xl text-white font-medium shadow-lg shadow-sky-500/30">
            <i class="fas fa-plus mr-2"></i>
            Tambah Aktivitas
        </a>
    </div>

    <!-- Data Table -->
    <div class="bg-white border border-slate-200 rounded-2xl overflow-hidden shadow-sm">
        <?php if (!empty($aktivitas)): ?>
            <div class="overflow-x-auto">
                <table class="table-modern w-full">
                    <thead class="bg-slate-50">
                        <tr>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">No</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Tanggal</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Jam</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Nama Aktivitas</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Media</th>
                            <th class="px-6 py-4 text-center text-slate-600 font-semibold">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        <?php $no = 1; foreach ($aktivitas as $item): ?>
                            <tr class="hover:bg-slate-50 transition-colors">
                                <td class="px-6 py-4 text-slate-500"><?= $no++ ?></td>
                                <td class="px-6 py-4">
                                    <span class="text-slate-800 font-medium"><?= date('d M Y', strtotime($item['tanggal'])) ?></span>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="bg-blue-100 text-blue-600 px-3 py-1 rounded-full text-sm">
                                        <?= $item['jam'] ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="max-w-xs">
                                        <p class="text-slate-800 font-medium truncate"><?= esc($item['nama_aktivitas']) ?></p>
                                        <?php if (!empty($item['deskripsi'])): ?>
                                            <p class="text-slate-500 text-sm truncate"><?= esc($item['deskripsi']) ?></p>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center space-x-2">
                                        <?php if (!empty($item['foto'])): ?>
                                            <span class="bg-emerald-100 text-emerald-600 px-2 py-1 rounded text-xs">
                                                <i class="fas fa-image mr-1"></i>Foto
                                            </span>
                                        <?php endif; ?>
                                        <?php if (!empty($item['video'])): ?>
                                            <span class="bg-purple-100 text-purple-600 px-2 py-1 rounded text-xs">
                                                <i class="fas fa-video mr-1"></i>Video
                                            </span>
                                        <?php endif; ?>
                                        <?php if (empty($item['foto']) && empty($item['video'])): ?>
                                            <span class="text-slate-400 text-sm">-</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center justify-center space-x-2">
                                        <a href="<?= base_url('admin/aktivitas/edit/' . $item['id']) ?>" 
                                           class="p-2 bg-blue-100 text-blue-600 rounded-lg hover:bg-blue-200 transition-colors"
                                           title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form id="deleteForm<?= $item['id'] ?>" action="<?= base_url('admin/aktivitas/delete/' . $item['id']) ?>" method="POST" class="inline">
                                            <?= csrf_field() ?>
                                            <button type="button" 
                                                    onclick="confirmDelete('deleteForm<?= $item['id'] ?>', '<?= esc($item['nama_aktivitas']) ?>')" 
                                                    class="p-2 bg-red-100 text-red-600 rounded-lg hover:bg-red-200 transition-colors"
                                                    title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="px-6 py-16 text-center">
                <div class="w-20 h-20 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4 text-slate-400">
                    <i class="fas fa-calendar-times text-3xl"></i>
                </div>
                <h3 class="text-xl font-medium text-slate-800 mb-2">Belum Ada Aktivitas</h3>
                <p class="text-slate-500 mb-6">Mulai tambahkan aktivitas harian Anda</p>
                <a href="<?= base_url('admin/aktivitas/create') ?>" class="btn-primary inline-flex items-center px-6 py-3 rounded-xl text-white font-medium shadow-lg shadow-sky-500/30">
                    <i class="fas fa-plus mr-2"></i>
                    Tambah Aktivitas Pertama
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>
