<?php

namespace App\Models;

use CodeIgniter\Model;

class RiwayatPendidikanModel extends Model
{
    protected $table            = 'riwayat_pendidikan';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['jenjang', 'nama_sekolah', 'tahun_masuk', 'tahun_lulus', 'jurusan', 'nilai_akhir'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'jenjang'      => 'required|in_list[SD,SMP,SMA,Kuliah]',
        'nama_sekolah' => 'required|min_length[3]|max_length[255]',
        'tahun_masuk'  => 'required|numeric|exact_length[4]',
    ];

    protected $validationMessages = [
        'jenjang' => [
            'required' => 'Jenjang pendidikan wajib dipilih.',
            'in_list'  => 'Jenjang harus SD, SMP, SMA, atau Kuliah.',
        ],
        'nama_sekolah' => [
            'required'   => 'Nama sekolah/universitas wajib diisi.',
            'min_length' => 'Nama sekolah minimal 3 karakter.',
        ],
        'tahun_masuk' => [
            'required'     => 'Tahun masuk wajib diisi.',
            'numeric'      => 'Tahun masuk harus berupa angka.',
            'exact_length' => 'Tahun masuk harus 4 digit.',
        ],
    ];

    protected $skipValidation = false;

    /**
     * Get all education ordered by level
     */
    public function getOrderedByLevel()
    {
        $order = ['SD' => 1, 'SMP' => 2, 'SMA' => 3, 'Kuliah' => 4];
        $results = $this->findAll();
        
        usort($results, function($a, $b) use ($order) {
            return ($order[$a['jenjang']] ?? 5) - ($order[$b['jenjang']] ?? 5);
        });
        
        return $results;
    }

    /**
     * Search education by keyword
     */
    public function search(string $keyword)
    {
        return $this->like('nama_sekolah', $keyword)
                    ->orLike('jurusan', $keyword);
    }
}
