<?php

namespace App\Models;

use CodeIgniter\Model;

class AktivitasModel extends Model
{
    protected $table            = 'aktivitas_harian';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['tanggal', 'jam', 'nama_aktivitas', 'deskripsi', 'foto', 'video'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'tanggal'        => 'required|valid_date',
        'jam'            => 'required',
        'nama_aktivitas' => 'required|min_length[3]|max_length[255]',
    ];

    protected $validationMessages = [
        'tanggal' => [
            'required'   => 'Tanggal wajib diisi.',
            'valid_date' => 'Format tanggal tidak valid.',
        ],
        'jam' => [
            'required' => 'Jam wajib diisi.',
        ],
        'nama_aktivitas' => [
            'required'   => 'Nama aktivitas wajib diisi.',
            'min_length' => 'Nama aktivitas minimal 3 karakter.',
        ],
    ];

    protected $skipValidation = false;

    /**
     * Search activities by keyword
     */
    public function search(string $keyword)
    {
        return $this->like('nama_aktivitas', $keyword)
                    ->orLike('deskripsi', $keyword);
    }

    /**
     * Filter activities by date range
     */
    public function filterByDate(?string $startDate, ?string $endDate)
    {
        if ($startDate) {
            $this->where('tanggal >=', $startDate);
        }
        if ($endDate) {
            $this->where('tanggal <=', $endDate);
        }
        return $this;
    }
}
