<?php

namespace App\Controllers\Frontend;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;

class Aktivitas extends BaseController
{
    protected $aktivitasModel;

    public function __construct()
    {
        $this->aktivitasModel = new AktivitasModel();
    }

    public function index()
    {
        // Get query parameters
        $search = $this->request->getGet('search');
        $startDate = $this->request->getGet('start_date');
        $endDate = $this->request->getGet('end_date');
        $sort = $this->request->getGet('sort') ?? 'tanggal';
        $order = $this->request->getGet('order') ?? 'DESC';
        $page = $this->request->getGet('page') ?? 1;
        $perPage = 10;

        // Build query
        $builder = $this->aktivitasModel;

        // Search filter (minimum 3 characters)
        if ($search && strlen($search) >= 3) {
            $builder = $builder->groupStart()
                ->like('nama_aktivitas', $search)
                ->orLike('deskripsi', $search)
                ->groupEnd();
        } elseif ($search && strlen($search) < 3) {
            $search = ''; // Reset search if less than 3 chars
        }

        // Date filter
        if ($startDate) {
            $builder = $builder->where('tanggal >=', $startDate);
        }
        if ($endDate) {
            $builder = $builder->where('tanggal <=', $endDate);
        }

        // Sorting
        $allowedSorts = ['tanggal', 'jam', 'nama_aktivitas'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'tanggal';
        $order = strtoupper($order) === 'ASC' ? 'ASC' : 'DESC';

        // Get total count for pagination
        $total = $builder->countAllResults(false);

        // Get paginated data
        $aktivitas = $builder->orderBy($sort, $order)
                            ->paginate($perPage, 'default', $page);

        $data = [
            'title' => 'Aktivitas Harian',
            'aktivitas' => $aktivitas,
            'pager' => $this->aktivitasModel->pager,
            'total' => $total,
            'search' => $search,
            'startDate' => $startDate,
            'endDate' => $endDate,
            'sort' => $sort,
            'order' => $order,
            'currentPage' => $page,
        ];

        return view('frontend/aktivitas', $data);
    }
}
