<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\RiwayatPendidikanModel;

class Pendidikan extends BaseController
{
    protected $pendidikanModel;

    public function __construct()
    {
        $this->pendidikanModel = new RiwayatPendidikanModel();
    }

    /**
     * Display education list
     */
    public function index()
    {
        $data = [
            'title' => 'Riwayat Pendidikan',
            'pendidikan' => $this->pendidikanModel->getOrderedByLevel(),
        ];

        return view('admin/pendidikan/index', $data);
    }

    /**
     * Show create form
     */
    public function create()
    {
        $data = [
            'title' => 'Tambah Riwayat Pendidikan',
            'jenjangOptions' => ['SD', 'SMP', 'SMA', 'Kuliah'],
        ];

        return view('admin/pendidikan/create', $data);
    }

    /**
     * Store new education record
     */
    public function store()
    {
        $rules = [
            'jenjang' => 'required|in_list[SD,SMP,SMA,Kuliah]',
            'nama_sekolah' => 'required|min_length[3]|max_length[255]',
            'tahun_masuk' => 'required|numeric|exact_length[4]',
            'tahun_lulus' => 'permit_empty|numeric|exact_length[4]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'jenjang' => $this->request->getPost('jenjang'),
            'nama_sekolah' => $this->request->getPost('nama_sekolah'),
            'tahun_masuk' => $this->request->getPost('tahun_masuk'),
            'tahun_lulus' => $this->request->getPost('tahun_lulus') ?: null,
            'jurusan' => $this->request->getPost('jurusan'),
            'nilai_akhir' => $this->request->getPost('nilai_akhir'),
        ];

        $this->pendidikanModel->insert($data);

        return redirect()->to('/admin/pendidikan')->with('success', 'Riwayat pendidikan berhasil ditambahkan!');
    }

    /**
     * Show edit form
     */
    public function edit($id)
    {
        $pendidikan = $this->pendidikanModel->find($id);

        if (!$pendidikan) {
            return redirect()->to('/admin/pendidikan')->with('error', 'Data tidak ditemukan.');
        }

        $data = [
            'title' => 'Edit Riwayat Pendidikan',
            'pendidikan' => $pendidikan,
            'jenjangOptions' => ['SD', 'SMP', 'SMA', 'Kuliah'],
        ];

        return view('admin/pendidikan/edit', $data);
    }

    /**
     * Update education record
     */
    public function update($id)
    {
        $pendidikan = $this->pendidikanModel->find($id);

        if (!$pendidikan) {
            return redirect()->to('/admin/pendidikan')->with('error', 'Data tidak ditemukan.');
        }

        $rules = [
            'jenjang' => 'required|in_list[SD,SMP,SMA,Kuliah]',
            'nama_sekolah' => 'required|min_length[3]|max_length[255]',
            'tahun_masuk' => 'required|numeric|exact_length[4]',
            'tahun_lulus' => 'permit_empty|numeric|exact_length[4]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'jenjang' => $this->request->getPost('jenjang'),
            'nama_sekolah' => $this->request->getPost('nama_sekolah'),
            'tahun_masuk' => $this->request->getPost('tahun_masuk'),
            'tahun_lulus' => $this->request->getPost('tahun_lulus') ?: null,
            'jurusan' => $this->request->getPost('jurusan'),
            'nilai_akhir' => $this->request->getPost('nilai_akhir'),
        ];

        $this->pendidikanModel->update($id, $data);

        return redirect()->to('/admin/pendidikan')->with('success', 'Riwayat pendidikan berhasil diperbarui!');
    }

    /**
     * Delete education record
     */
    public function delete($id)
    {
        $pendidikan = $this->pendidikanModel->find($id);

        if (!$pendidikan) {
            return redirect()->to('/admin/pendidikan')->with('error', 'Data tidak ditemukan.');
        }

        $this->pendidikanModel->delete($id);

        return redirect()->to('/admin/pendidikan')->with('success', 'Riwayat pendidikan berhasil dihapus!');
    }
}
