<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// ============================================
// Authentication Routes
// ============================================
$routes->get('login', 'Auth::login');
$routes->post('login', 'Auth::attemptLogin');
$routes->get('logout', 'Auth::logout');

// ============================================
// Admin Routes (Protected)
// ============================================
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    // Dashboard
    $routes->get('/', 'Admin\Dashboard::index');
    $routes->get('dashboard', 'Admin\Dashboard::index');
    
    // Aktivitas Harian CRUD
    $routes->get('aktivitas', 'Admin\Aktivitas::index');
    $routes->get('aktivitas/create', 'Admin\Aktivitas::create');
    $routes->post('aktivitas/store', 'Admin\Aktivitas::store');
    $routes->get('aktivitas/edit/(:num)', 'Admin\Aktivitas::edit/$1');
    $routes->post('aktivitas/update/(:num)', 'Admin\Aktivitas::update/$1');
    $routes->post('aktivitas/delete/(:num)', 'Admin\Aktivitas::delete/$1');
    
    // Biodata CRUD
    $routes->get('biodata', 'Admin\Biodata::index');
    $routes->get('biodata/create', 'Admin\Biodata::create');
    $routes->post('biodata/store', 'Admin\Biodata::store');
    $routes->get('biodata/edit/(:num)', 'Admin\Biodata::edit/$1');
    $routes->post('biodata/update/(:num)', 'Admin\Biodata::update/$1');
    $routes->post('biodata/delete/(:num)', 'Admin\Biodata::delete/$1');
    $routes->post('biodata/activate/(:num)', 'Admin\Biodata::activate/$1');
    
    // Riwayat Pendidikan CRUD
    $routes->get('pendidikan', 'Admin\Pendidikan::index');
    $routes->get('pendidikan/create', 'Admin\Pendidikan::create');
    $routes->post('pendidikan/store', 'Admin\Pendidikan::store');
    $routes->get('pendidikan/edit/(:num)', 'Admin\Pendidikan::edit/$1');
    $routes->post('pendidikan/update/(:num)', 'Admin\Pendidikan::update/$1');
    $routes->post('pendidikan/delete/(:num)', 'Admin\Pendidikan::delete/$1');
});

// ============================================
// Frontend Routes (Public)
// ============================================
$routes->get('/', 'Frontend\Home::index');
$routes->get('aktivitas', 'Frontend\Aktivitas::index');
$routes->get('profile', 'Frontend\Profile::index');
$routes->get('pendidikan', 'Frontend\Pendidikan::index');
