<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? esc($title) : 'Portfolio Digital' ?></title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    
    <!-- Three.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
    
    <style>
        :root {
            --primary-color: #0ea5e9;
            --secondary-color: #f97316;
            --dark-color: #0f172a;
            --light-color: #f8fafc;
            --accent-color: #22c55e;
            --gradient: linear-gradient(135deg, #0ea5e9, #f97316);
            --glass: rgba(255, 255, 255, 0.82);
            --stroke: rgba(15, 23, 42, 0.08);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: radial-gradient(circle at 12% 20%, rgba(14,165,233,0.12), transparent 22%),
                        radial-gradient(circle at 78% 10%, rgba(249,115,22,0.12), transparent 20%),
                        radial-gradient(circle at 30% 80%, rgba(34,197,94,0.10), transparent 22%),
                        #edf2f7;
            color: var(--dark-color);
            line-height: 1.6;
            overflow-x: hidden;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* Navigation */
        .navbar {
            background: linear-gradient(120deg, rgba(15,23,42,0.9), rgba(15,23,42,0.82));
            backdrop-filter: blur(12px);
            padding: calc(1rem + env(safe-area-inset-top, 0px)) 0 1rem;
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
            box-shadow: 0 12px 40px rgba(15,23,42,0.25);
            border-bottom: 1px solid rgba(255,255,255,0.08);
        }
        
        .nav-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
            position: relative;
        }
        
        .logo {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-family: 'Montserrat', sans-serif;
            font-size: 1.45rem;
            font-weight: 800;
            letter-spacing: 0.5px;
            color: #f8fafc;
        }

        .logo .logo-pill {
            display: grid;
            place-items: center;
            width: 34px;
            height: 34px;
            border-radius: 12px;
            background: var(--gradient);
            color: #0b1222;
            font-size: 0.9rem;
            font-weight: 800;
            box-shadow: 0 8px 24px rgba(14,165,233,0.28);
        }

        .logo .logo-text {
            background: linear-gradient(120deg, #e2e8f0, #cbd5e1);
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-transform: uppercase;
        }
        
        .nav-links {
            display: flex;
            gap: 1rem;
            list-style: none;
            align-items: center;
        }

        .nav-links a {
            text-decoration: none;
            color: #e2e8f0;
            font-weight: 600;
            transition: all 0.2s ease;
            padding: 10px 14px;
            border-radius: 12px;
            border: 1px solid transparent;
            background: rgba(255,255,255,0.04);
        }
        
        .nav-links a:hover {
            color: white;
            border-color: rgba(255,255,255,0.12);
        }
        
        .nav-links a.active {
            background: var(--gradient);
            color: white;
            border-color: transparent;
            box-shadow: 0 12px 30px rgba(14,165,233,0.25);
        }

        .mobile-menu-btn {
            display: none;
            padding: 8px 10px;
            border-radius: 12px;
            border: 1px solid rgba(255,255,255,0.25);
            background: rgba(255,255,255,0.08);
            color: #e2e8f0;
        }
        
        /* Hero Section */
        .hero {
            min-height: 100vh;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            align-items: center;
            padding: 140px 0 90px;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            inset: 0;
            background: radial-gradient(900px circle at 18% 18%, rgba(14,165,233,0.15), transparent 40%),
                        radial-gradient(1100px circle at 85% 25%, rgba(249,115,22,0.16), transparent 45%);
            z-index: 0;
        }
        
        #canvas3d {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
            pointer-events: none;
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
            max-width: 640px;
            background: var(--glass);
            border: 1px solid rgba(255,255,255,0.45);
            backdrop-filter: blur(12px);
            border-radius: 22px;
            padding: 32px;
            box-shadow: 0 20px 60px rgba(15,23,42,0.16);
        }
        
        .hero h1 {
            font-size: clamp(2.4rem, 4vw, 3.4rem);
            font-weight: 800;
            margin-bottom: 1rem;
            color: var(--dark-color);
        }
        
        .hero p {
            font-size: 1.1rem;
            color: #475569;
            margin-bottom: 2rem;
        }

        .hero .tagline {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 9px 14px;
            border-radius: 12px;
            background: rgba(14,165,233,0.14);
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 16px;
            font-size: 0.95rem;
            letter-spacing: 0.2px;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: var(--gradient);
            color: white;
            border: none;
            border-radius: 16px;
            text-decoration: none;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.25s, box-shadow 0.25s;
            box-shadow: 0 12px 30px rgba(14, 165, 233, 0.28);
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 16px 40px rgba(249, 115, 22, 0.25);
        }

        .btn.secondary {
            background: transparent;
            color: var(--dark-color);
            border: 2px solid #e2e8f0;
            box-shadow: none;
        }

        .btn.secondary:hover {
            background: rgba(14,165,233,0.08);
            box-shadow: none;
            border-color: rgba(14,165,233,0.2);
        }
        
        /* Sections */
        section {
            padding: 96px 0;
            scroll-margin-top: 90px;
        }
        
        .section-title {
            text-align: center;
            font-size: 2.25rem;
            margin-bottom: 2.5rem;
            position: relative;
            color: var(--dark-color);
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: -12px;
            left: 50%;
            transform: translateX(-50%);
            width: 120px;
            height: 4px;
            background: var(--gradient);
            border-radius: 999px;
        }

        .muted {
            color: #475569;
        }

        .pill {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            background: #eef2ff;
            color: #4338ca;
            border-radius: 999px;
            font-size: 0.95rem;
            font-weight: 600;
        }

        .card-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
            gap: 1.5rem;
        }
        
        /* Cards */
        .card {
            background: white;
            border-radius: 20px;
            padding: 2rem;
            box-shadow: 0 14px 34px rgba(15,23,42,0.12);
            transition: transform 0.25s, box-shadow 0.25s;
            border: 1px solid var(--stroke);
        }
        
        .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 44px rgba(14,165,233,0.16);
        }
        
        /* Filter & Search */
        .filter-section {
            background: white;
            padding: 1.5rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        }
        
        .filter-form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            align-items: end;
        }
        
        .form-group {
            display: flex;
            flex-direction: column;
        }
        
        .form-group label {
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: var(--dark-color);
        }
        
        .form-control {
            padding: 10px 15px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-family: 'Poppins', sans-serif;
            font-size: 1rem;
            transition: border-color 0.3s;
            background: #fff;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37,99,235,0.15);
        }
        
        /* Table */
        .table-container {
            overflow-x: auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 12px 30px rgba(15,23,42,0.08);
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.95rem;
        }
        
        th, td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }
        
        th {
            background: #f1f5f9;
            font-weight: 600;
            color: var(--dark-color);
            cursor: pointer;
            user-select: none;
        }
        
        th:hover {
            background: #e2e8f0;
        }
        
        tr:hover {
            background: #f8fafc;
        }
        
        /* Pagination */
        .pagination {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            margin-top: 2rem;
        }
        
        .page-item {
            list-style: none;
        }
        
        .page-link {
            display: block;
            padding: 0.5rem 1rem;
            background: white;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            text-decoration: none;
            color: var(--dark-color);
            transition: all 0.3s;
        }
        
        .page-link:hover {
            background: var(--light-color);
            border-color: var(--primary-color);
        }
        
        .page-item.active .page-link {
            background: var(--gradient);
            color: white;
            border-color: transparent;
        }
        
        /* Gallery */
        .gallery {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 1.5rem;
        }
        
        .gallery-item {
            position: relative;
            border-radius: 15px;
            overflow: hidden;
            aspect-ratio: 16/9;
        }
        
        .gallery-item img, .gallery-item video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .gallery-item:hover img, .gallery-item:hover video {
            transform: scale(1.05);
        }
        
        .gallery-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(transparent, rgba(0,0,0,0.8));
            padding: 1rem;
            color: white;
            transform: translateY(100%);
            transition: transform 0.3s;
        }
        
        .gallery-item:hover .gallery-overlay {
            transform: translateY(0);
        }

        .empty-state {
            text-align: center;
            padding: 2.5rem;
            color: #94a3b8;
            border: 1px dashed #cbd5e1;
            border-radius: 16px;
            background: #f8fafc;
        }
        
        /* Footer */
        footer {
            background: #0b1222;
            color: white;
            padding: 3rem 0;
            text-align: center;
        }
        
        .social-links {
            display: flex;
            justify-content: center;
            gap: 1.1rem;
            margin-bottom: 1rem;
        }
        
        .social-links a {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 48px;
            height: 48px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            color: white;
            text-decoration: none;
            transition: background 0.3s, transform 0.3s;
            font-size: 1.15rem;
        }
        
        .social-links a:hover {
            background: var(--primary-color);
            transform: translateY(-3px);
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.3rem;
            }
            
            .mobile-menu-btn {
                display: inline-flex;
                background: rgba(255,255,255,0.08);
                border: 1px solid rgba(255,255,255,0.2);
                font-size: 1.4rem;
                color: #e2e8f0;
                cursor: pointer;
            }

            .nav-links {
                display: none;
                flex-direction: column;
                position: absolute;
                top: calc(100% + 12px + env(safe-area-inset-top, 0px));
                left: 12px;
                right: 12px;
                background: #0b1222;
                padding: 14px;
                border-radius: 14px;
                box-shadow: 0 22px 50px rgba(0,0,0,0.35);
                gap: 12px;
                border: 1px solid rgba(255,255,255,0.08);
                z-index: 1100;
            }

            .nav-links a {
                width: 100%;
                background: rgba(255,255,255,0.04);
                border: 1px solid rgba(255,255,255,0.06);
            }

            .nav-links.open {
                display: flex;
            }

            .container {
                padding: 0 16px;
            }
        }
    </style>
    
    <?= $this->renderSection('styles') ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="container nav-container">
            <div class="logo">
                <span class="logo-pill">RW</span>
                <span class="logo-text">Ridwan Web</span>
            </div>
            <ul class="nav-links">
                <li><a href="<?= base_url() ?>" class="<?= url_is('/') ? 'active' : '' ?>">Home</a></li>
                <li><a href="<?= base_url('cv') ?>" class="<?= url_is('cv') ? 'active' : '' ?>">Biodata</a></li>
                <li><a href="<?= base_url('pendidikan') ?>" class="<?= url_is('pendidikan') ? 'active' : '' ?>">Pendidikan</a></li>
                <li><a href="<?= base_url('aktivitas') ?>" class="<?= url_is('aktivitas') ? 'active' : '' ?>">Aktivitas</a></li>
                <li><a href="<?= base_url('admin/login') ?>" class="<?= url_is('admin*') ? 'active' : '' ?>">Login</a></li>
            </ul>
            <button class="mobile-menu-btn" aria-label="Toggle navigation" type="button">
                <i class="fas fa-bars"></i>
            </button>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="social-links">
                <a href="https://wa.me/6285719678058" target="_blank" rel="noopener" aria-label="WhatsApp 085719678058" title="WhatsApp 085719678058"><i class="fab fa-whatsapp"></i></a>
                <a href="https://www.instagram.com/papa.lotta_?igsh=aWJ0NzlhOTVzMTF6" target="_blank" rel="noopener" aria-label="Instagram papa.lotta_" title="Instagram papa.lotta_"><i class="fab fa-instagram"></i></a>
                <a href="https://youtube.com/@muhamadridwan_2024?si=bLmvPliXEjFmMVUm" target="_blank" rel="noopener" aria-label="YouTube muhamadridwan_2024" title="YouTube muhamadridwan_2024"><i class="fab fa-youtube"></i></a>
                <a href="https://www.tiktok.com/@muhamad_ridwan06?_r=1&_t=ZS-92H0HOeIFJF" target="_blank" rel="noopener" aria-label="TikTok @muhamad_ridwan06" title="TikTok @muhamad_ridwan06"><i class="fab fa-tiktok"></i></a>
            </div>
            <p>&copy; <?= date('Y') ?> Muhamad Ridwan Portofolio. All rights reserved.</p>
        </div>
    </footer>

    <!-- 3D Script -->
    <script>
        // Three.js 3D Background
        function init3DBackground() {
            const heroSection = document.querySelector('.hero');
            if (!heroSection) return;

            const canvas = document.createElement('canvas');
            canvas.id = 'canvas3d';
            heroSection.appendChild(canvas);

            if (!window.THREE || !canvas.getContext('webgl')) {
                // Fallback: keep gradient background only
                return;
            }

            const scene = new THREE.Scene();
            const camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000);
            const renderer = new THREE.WebGLRenderer({ canvas, alpha: true });
            renderer.setSize(window.innerWidth, window.innerHeight);
            renderer.setPixelRatio(Math.min(window.devicePixelRatio || 1, 1.5));
            
            // Geometry
            const geometry = new THREE.IcosahedronGeometry(1, 0);
            const material = new THREE.MeshPhongMaterial({
                color: 0x2563eb,
                shininess: 100,
                transparent: true,
                opacity: 0.6
            });
            
            const shapes = [];
            const totalShapes = window.innerWidth < 768 ? 18 : 28;
            for (let i = 0; i < totalShapes; i++) {
                const shape = new THREE.Mesh(geometry, material);
                shape.position.x = Math.random() * 40 - 20;
                shape.position.y = Math.random() * 40 - 20;
                shape.position.z = Math.random() * 40 - 20;
                shape.scale.setScalar(Math.random() * 2 + 0.5);
                shapes.push(shape);
                scene.add(shape);
            }
            
            // Lights
            const light1 = new THREE.DirectionalLight(0xffffff, 0.8);
            light1.position.set(1, 1, 1);
            scene.add(light1);
            
            const light2 = new THREE.AmbientLight(0x404040);
            scene.add(light2);
            
            camera.position.z = 5;
            
            // Animation
            function animate() {
                requestAnimationFrame(animate);
                
                shapes.forEach((shape, i) => {
                    shape.rotation.x += 0.005;
                    shape.rotation.y += 0.01;
                    shape.position.y += Math.sin(Date.now() * 0.001 + i) * 0.005;
                });
                
                renderer.render(scene, camera);
            }
            
            animate();
            
            // Resize handler
            window.addEventListener('resize', () => {
                camera.aspect = window.innerWidth / window.innerHeight;
                camera.updateProjectionMatrix();
                renderer.setSize(window.innerWidth, window.innerHeight);
            });
        }
        
        // Initialize on load
        document.addEventListener('DOMContentLoaded', function() {
            init3DBackground();
            
            // Mobile Menu
            const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
            const navLinks = document.querySelector('.nav-links');
            if (mobileMenuBtn) {
                mobileMenuBtn.addEventListener('click', function() {
                    if (!navLinks) return;
                    navLinks.classList.toggle('open');
                });
            }

            // Close menu on link click (mobile)
            if (navLinks) {
                navLinks.querySelectorAll('a').forEach(link => {
                    link.addEventListener('click', () => navLinks.classList.remove('open'));
                });
            }
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
