<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? esc($title) : 'Admin Panel' ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #0ea5e9;
            --secondary-color: #f97316;
            --dark-color: #0b1222;
            --light-color: #f8fafc;
            --muted-color: #94a3b8;
            --gradient: linear-gradient(135deg, #0ea5e9, #f97316);
            --panel: rgba(255,255,255,0.86);
            --stroke: rgba(15,23,42,0.08);
        }
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            font-family: 'Poppins', sans-serif;
            background:
                radial-gradient(circle at 14% 22%, rgba(14,165,233,0.14), transparent 26%),
                radial-gradient(circle at 82% 12%, rgba(249,115,22,0.14), transparent 30%),
                radial-gradient(circle at 32% 80%, rgba(34,197,94,0.12), transparent 26%),
                #eef2f7;
            color: var(--dark-color);
            line-height: 1.6;
            min-height: 100vh;
        }
        a { color: inherit; text-decoration: none; }

        /* Navbar */
        .admin-nav {
            position: sticky;
            top: 0;
            z-index: 20;
            background: linear-gradient(120deg, rgba(11,18,34,0.94), rgba(11,18,34,0.88));
            color: white;
            box-shadow: 0 10px 36px rgba(11,18,34,0.35);
            border-bottom: 1px solid rgba(255,255,255,0.06);
        }
        .admin-nav .inner {
            max-width: 1240px;
            margin: 0 auto;
            padding: 16px 22px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 18px;
            position: relative;
        }
        .admin-brand {
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 700;
            letter-spacing: 0.5px;
            font-size: 1.05rem;
        }
        .admin-brand i { color: #22d3ee; }
        .admin-links {
            display: flex;
            align-items: center;
            gap: 12px;
            flex-wrap: wrap;
        }
        .admin-links a {
            padding: 10px 14px;
            border-radius: 12px;
            color: #e2e8f0;
            transition: background 0.2s, color 0.2s, transform 0.2s, border 0.2s;
            font-weight: 600;
            border: 1px solid transparent;
            background: rgba(255,255,255,0.04);
        }
        .admin-links a:hover,
        .admin-links a.active {
            background: var(--gradient);
            color: #fff;
            transform: translateY(-1px);
            border-color: transparent;
            box-shadow: 0 12px 28px rgba(14,165,233,0.25);
        }
        .admin-links .btn {
            padding: 9px 14px;
        }

        .admin-menu-btn {
            display: none;
            padding: 8px 10px;
            border-radius: 12px;
            border: 1px solid rgba(255,255,255,0.3);
            background: rgba(255,255,255,0.08);
            color: white;
            cursor: pointer;
        }

        /* Layout base */
        .container {
            max-width: 1240px;
            margin: 0 auto;
            padding: 0 22px 42px;
        }
        .content {
            padding-top: 28px;
        }
        section {
            padding: 24px 0;
        }

        /* Cards & shells */
        .card {
            background: white;
            border-radius: 18px;
            border: 1px solid var(--stroke);
            box-shadow: 0 16px 40px rgba(11,18,34,0.12);
            padding: 20px;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 20px 48px rgba(14,165,233,0.2);
        }
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 12px;
            flex-wrap: wrap;
            margin-bottom: 12px;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 18px;
            border-radius: 12px;
            background: var(--gradient);
            color: white;
            border: none;
            cursor: pointer;
            font-weight: 600;
            box-shadow: 0 12px 28px rgba(14,165,233,0.25);
            transition: transform 0.15s ease, box-shadow 0.15s ease, opacity 0.15s ease;
        }
        .btn:hover { transform: translateY(-1px); box-shadow: 0 14px 30px rgba(37,99,235,0.32); }
        .btn.secondary {
            background: #e2e8f0;
            color: #0f172a;
            box-shadow: none;
        }
        .btn.danger {
            background: linear-gradient(135deg, #ef4444, #b91c1c);
            box-shadow: 0 10px 20px rgba(239,68,68,0.3);
        }

        /* Forms */
        .form-group { display: flex; flex-direction: column; gap: 6px; }
        .form-control, select {
            padding: 10px 12px;
            border-radius: 10px;
            border: 1.5px solid #e2e8f0;
            background: #fff;
            font-family: 'Poppins', sans-serif;
            font-size: 0.95rem;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        .form-control:focus, select:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37,99,235,0.15);
        }
        .filter-section {
            background: white;
            border: 1px solid #e2e8f0;
            border-radius: 14px;
            box-shadow: 0 12px 30px rgba(15,23,42,0.1);
        }
        .filter-form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 12px;
            padding: 14px;
        }

        /* Tables */
        .table-container {
            overflow: hidden;
            border-radius: 14px;
            border: 1px solid #e2e8f0;
            box-shadow: 0 16px 32px rgba(15,23,42,0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.95rem;
        }
        th, td {
            padding: 12px 14px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }
        th {
            background: #f8fafc;
            font-weight: 700;
            color: #0f172a;
        }
        tr:nth-child(even) td { background: #fbfdff; }
        tr:hover td { background: #f1f5f9; }

        /* Pills & badges */
        .pill { display: inline-flex; align-items: center; gap: 6px; padding: 6px 10px; border-radius: 999px; font-weight: 600; }
        .badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 6px 10px;
            border-radius: 999px;
            font-weight: 600;
            background: #e0f2fe;
            color: #0369a1;
            border: 1px solid #bae6fd;
        }

        /* Pagination */
        .pagination {
            display: flex;
            justify-content: center;
            gap: 8px;
            padding: 16px 0;
        }
        .pagination .page-link {
            display: inline-block;
            padding: 8px 12px;
            border-radius: 10px;
            border: 1px solid #e2e8f0;
            background: white;
            color: #0f172a;
        }
        .pagination .page-item.active .page-link {
            background: var(--gradient);
            color: white;
            border: none;
        }

        /* Helpers */
        .section-title-admin {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 1.6rem;
            font-weight: 800;
            color: #0f172a;
        }
        .page-shell {
            background: white;
            border-radius: 18px;
            padding: 18px 20px;
            border: 1px solid #e2e8f0;
            box-shadow: 0 12px 32px rgba(15,23,42,0.08);
            margin-bottom: 20px;
        }

        @media (max-width: 768px) {
            .admin-nav .inner {
                padding: 12px 16px;
            }

            .admin-menu-btn {
                display: inline-flex;
                align-items: center;
                justify-content: center;
                font-size: 1.2rem;
            }

            .admin-links {
                display: none;
                flex-direction: column;
                align-items: flex-start;
                position: absolute;
                top: calc(100% + 10px);
                right: 16px;
                left: 16px;
                padding: 14px;
                background: #0b152d;
                border-radius: 14px;
                box-shadow: 0 16px 32px rgba(0,0,0,0.25);
                z-index: 30;
            }

            .admin-links a {
                width: 100%;
                padding: 10px 12px;
                border-radius: 10px;
                background: rgba(255,255,255,0.05);
            }

            .admin-links .btn {
                width: 100%;
                justify-content: center;
                text-align: center;
            }

            .admin-links.open {
                display: flex;
            }

            .container {
                padding: 0 16px 32px;
            }

            .content {
                padding-top: 12px;
            }
        }
    </style>
</head>
<body>
    <nav class="admin-nav">
        <div class="inner">
            <div class="admin-brand">
                <i class="fas fa-shield-halved"></i> Admin Panel
            </div>
            <button class="admin-menu-btn" aria-label="Toggle navigation">
                <i class="fas fa-bars"></i>
            </button>
            <div class="admin-links">
                <a href="<?= base_url('admin') ?>" class="<?= url_is('admin') ? 'active' : '' ?>">Dashboard</a>
                <a href="<?= base_url('admin/biodata') ?>" class="<?= url_is('admin/biodata*') ? 'active' : '' ?>">Biodata</a>
                <a href="<?= base_url('admin/pendidikan') ?>" class="<?= url_is('admin/pendidikan*') ? 'active' : '' ?>">Pendidikan</a>
                <a href="<?= base_url('admin/aktivitas') ?>" class="<?= url_is('admin/aktivitas*') ? 'active' : '' ?>">Aktivitas</a>
                <a href="<?= base_url('admin/logout') ?>" class="btn secondary" style="padding:8px 14px;">Logout</a>
            </div>
        </div>
    </nav>

    <main class="content">
        <?= $this->renderSection('content') ?>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggleBtn = document.querySelector('.admin-menu-btn');
            const navLinks = document.querySelector('.admin-links');

            if (toggleBtn) {
                toggleBtn.addEventListener('click', function() {
                    if (!navLinks) return;
                    navLinks.classList.toggle('open');
                });
            }

            if (navLinks) {
                navLinks.querySelectorAll('a').forEach(link => {
                    link.addEventListener('click', () => navLinks.classList.remove('open'));
                });
            }
        });
    </script>
</body>
</html>
