<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-plus"></i> Tambah Pendidikan</h1>
            <a href="<?= base_url('admin/pendidikan') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <form method="POST" action="<?= base_url('admin/pendidikan/create') ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Jenjang *</label>
                    <select name="jenjang" class="form-control" required>
                        <option value="">Pilih Jenjang</option>
                        <option value="SD">SD</option>
                        <option value="SMP">SMP</option>
                        <option value="SMA">SMA</option>
                        <option value="S1">S1</option>
                        <option value="S2">S2</option>
                        <option value="S3">S3</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Institusi *</label>
                    <input type="text" name="institusi" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label>Jurusan</label>
                    <input type="text" name="jurusan" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Tahun Mulai</label>
                    <input type="number" name="tahun_mulai" class="form-control" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Tahun Selesai</label>
                    <input type="number" name="tahun_selesai" class="form-control" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="5"></textarea>
                </div>

                <div class="form-group">
                    <label>Foto / Logo Institusi</label>
                    <input type="file" name="foto_file" class="form-control" accept="image/*">
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
