<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
    .admin-header h1 {
        color: var(--primary-color);
        margin: 0;
    }
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2rem;
    }
    .stat-card {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        text-align: center;
        transition: transform 0.3s;
    }
    .stat-card:hover {
        transform: translateY(-5px);
    }
    .stat-card i {
        font-size: 3rem;
        margin-bottom: 1rem;
        background: var(--gradient);
        -webkit-background-clip: text;
        background-clip: text;
        color: transparent;
    }
    .stat-card h3 {
        font-size: 2.5rem;
        margin: 0.5rem 0;
        color: var(--primary-color);
    }
    .stat-card p {
        color: #64748b;
        margin: 0;
    }
    .quick-actions {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
    }
    .action-btn {
        display: block;
        padding: 1.5rem;
        background: white;
        border-radius: 15px;
        text-decoration: none;
        text-align: center;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        transition: transform 0.3s, box-shadow 0.3s;
        color: var(--dark-color);
    }
    .action-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        color: var(--primary-color);
    }
    .action-btn i {
        font-size: 2rem;
        margin-bottom: 0.5rem;
        display: block;
    }
</style>

<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-tachometer-alt"></i> Dashboard Admin</h1>
            <a href="<?= base_url('admin/logout') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>

        <div class="stats-grid">
            <div class="stat-card">
                <i class="fas fa-user"></i>
                <h3><?= $biodata_count ?></h3>
                <p>Biodata</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-graduation-cap"></i>
                <h3><?= $pendidikan_count ?></h3>
                <p>Pendidikan</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-calendar-check"></i>
                <h3><?= $aktivitas_count ?></h3>
                <p>Aktivitas</p>
            </div>
        </div>

        <div class="card">
            <h2 style="margin-bottom: 1.5rem; color: var(--primary-color);">Quick Actions</h2>
            <div class="quick-actions">
                <a href="<?= base_url('admin/biodata') ?>" class="action-btn">
                    <i class="fas fa-user-edit"></i>
                    <strong>Kelola Biodata</strong>
                </a>
                <a href="<?= base_url('admin/pendidikan') ?>" class="action-btn">
                    <i class="fas fa-school"></i>
                    <strong>Kelola Pendidikan</strong>
                </a>
                <a href="<?= base_url('admin/aktivitas') ?>" class="action-btn">
                    <i class="fas fa-images"></i>
                    <strong>Kelola Aktivitas</strong>
                </a>
            </div>
        </div>
    </div>
</section>
<?= $this->endSection() ?>


