<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
    .alert-success {
        background: #d1fae5;
        color: #065f46;
        padding: 1rem;
        border-radius: 10px;
        margin-bottom: 1rem;
        border: 1px solid #a7f3d0;
    }
</style>

<?php
    $search      = $search ?? '';
    $filterField = $filterField ?? '';
    $filterValue = $filterValue ?? '';
    $sortBy      = $sortBy ?? 'created_at';
    $sortDir     = $sortDir ?? 'desc';
    $pageParam   = $pageParam ?? 'page_biodata';

    $buildSortUrl = function (string $column) use ($search, $filterField, $filterValue, $sortBy, $sortDir, $pageParam) {
        $direction = ($sortBy === $column && $sortDir === 'asc') ? 'desc' : 'asc';
        $params    = array_filter([
            'search'       => $search,
            'filter_field' => $filterField,
            'filter_value' => $filterValue,
            'sort_by'      => $column,
            'sort_dir'     => $direction,
            $pageParam     => 1,
        ], 'strlen');

        return current_url() . '?' . http_build_query($params);
    };

    $sortIcon = function (string $column) use ($sortBy, $sortDir) {
        if ($sortBy !== $column) {
            return '<i class="fas fa-sort" aria-hidden="true"></i>';
        }

        return $sortDir === 'asc'
            ? '<i class="fas fa-arrow-up" aria-hidden="true"></i>'
            : '<i class="fas fa-arrow-down" aria-hidden="true"></i>';
    };

    $totalRows = isset($pager) ? $pager->getTotal('biodata') : count($biodata ?? []);
?>

<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-user"></i> Kelola Biodata</h1>
            <div>
                <a href="<?= base_url('admin') ?>" class="btn" style="padding: 10px 20px; margin-right: 10px;">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
                <a href="<?= base_url('admin/biodata/create') ?>" class="btn" style="padding: 10px 20px;">
                    <i class="fas fa-plus"></i> Tambah Biodata
                </a>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
        <div class="alert-success">
            <i class="fas fa-check-circle"></i> <?= session()->getFlashdata('success') ?>
        </div>
        <?php endif; ?>

        <div class="filter-section">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label for="search-biodata">Pencarian</label>
                    <input id="search-biodata" type="text" name="search" class="form-control" placeholder="Cari nama, email, telepon, keahlian..." value="<?= esc($search) ?>">
                </div>
                <div class="form-group">
                    <label for="filter-field">Filter kolom</label>
                    <select id="filter-field" name="filter_field" class="form-control">
                        <option value="">Semua kolom</option>
                        <option value="nama" <?= $filterField === 'nama' ? 'selected' : '' ?>>Nama</option>
                        <option value="email" <?= $filterField === 'email' ? 'selected' : '' ?>>Email</option>
                        <option value="telepon" <?= $filterField === 'telepon' ? 'selected' : '' ?>>Telepon</option>
                        <option value="keahlian" <?= $filterField === 'keahlian' ? 'selected' : '' ?>>Keahlian</option>
                        <option value="pengalaman" <?= $filterField === 'pengalaman' ? 'selected' : '' ?>>Pengalaman</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="filter-value">Nilai filter</label>
                    <input id="filter-value" type="text" name="filter_value" class="form-control" placeholder="Masukkan kata kunci filter" value="<?= esc($filterValue) ?>">
                </div>
                <div class="form-group">
                    <label for="sort-by">Urutkan</label>
                    <select id="sort-by" name="sort_by" class="form-control">
                        <option value="id" <?= $sortBy === 'id' ? 'selected' : '' ?>>ID</option>
                        <option value="nama" <?= $sortBy === 'nama' ? 'selected' : '' ?>>Nama</option>
                        <option value="email" <?= $sortBy === 'email' ? 'selected' : '' ?>>Email</option>
                        <option value="telepon" <?= $sortBy === 'telepon' ? 'selected' : '' ?>>Telepon</option>
                        <option value="created_at" <?= $sortBy === 'created_at' ? 'selected' : '' ?>>Tanggal dibuat</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="sort-dir">Arah urutan</label>
                    <select id="sort-dir" name="sort_dir" class="form-control">
                        <option value="asc" <?= $sortDir === 'asc' ? 'selected' : '' ?>>Naik (A-Z / 0-9)</option>
                        <option value="desc" <?= $sortDir === 'desc' ? 'selected' : '' ?>>Turun (Z-A / 9-0)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>&nbsp;</label>
                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                        <button type="submit" class="btn" style="padding: 10px 20px;">Terapkan</button>
                        <a href="<?= current_url() ?>" class="btn secondary" style="padding: 10px 20px;">Reset</a>
                    </div>
                </div>
            </form>
            <div class="muted" style="margin-top: 0.5rem;">
                Menampilkan <?= count($biodata ?? []) ?> dari <?= $totalRows ?> data (10 per halaman)
            </div>
        </div>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>
                            <a href="<?= $buildSortUrl('id') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                ID <?= $sortIcon('id') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('nama') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Nama <?= $sortIcon('nama') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('email') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Email <?= $sortIcon('email') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('telepon') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Telepon <?= $sortIcon('telepon') ?>
                            </a>
                        </th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($biodata)): ?>
                        <?php foreach ($biodata as $item): ?>
                        <tr>
                            <td><?= esc($item['id']) ?></td>
                            <td><?= esc($item['nama']) ?></td>
                            <td><?= esc($item['email']) ?></td>
                            <td><?= esc($item['telepon']) ?></td>
                            <td>
                                <a href="<?= base_url('admin/biodata/edit/' . $item['id']) ?>" class="btn" style="padding: 5px 15px; font-size: 0.9rem; margin-right: 5px;">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <form method="POST" action="<?= base_url('admin/biodata/delete/' . $item['id']) ?>" style="display:inline;">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="btn" style="padding: 5px 15px; font-size: 0.9rem; background: #ef4444;" onclick="return confirm('Yakin ingin menghapus?')">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" style="text-align: center; padding: 2rem; color: #64748b;">
                                Belum ada data biodata
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if (isset($pager)): ?>
        <div class="pagination">
            <?= $pager->links('biodata', 'default_full') ?>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
