<!DOCTYPE html>
<html lang="id" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Portofolio' ?></title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        .gradient-purple {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        
        .btn-purple {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            transition: all 0.3s ease;
        }
        
        .btn-purple:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        }
        
        .nav-link {
            position: relative;
            transition: all 0.3s ease;
        }
        
        .nav-link::after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            bottom: -5px;
            left: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }
        
        .nav-link:hover::after,
        .nav-link.active::after {
            width: 100%;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.6s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .animate-slide-in {
            animation: slideIn 0.8s ease-out;
        }
        
        @keyframes slideIn {
            from { opacity: 0; transform: translateX(-30px); }
            to { opacity: 1; transform: translateX(0); }
        }
    </style>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        purple: {
                            50: '#f5f3ff',
                            100: '#ede9fe',
                            200: '#ddd6fe',
                            300: '#c4b5fd',
                            400: '#a78bfa',
                            500: '#8b5cf6',
                            600: '#7c3aed',
                            700: '#6d28d9',
                            800: '#5b21b6',
                            900: '#4c1d95',
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <a href="<?= base_url('/') ?>" class="flex items-center space-x-2">
                        <div class="w-8 h-8 gradient-purple rounded-lg flex items-center justify-center">
                            <i class="fas fa-user text-white text-sm"></i>
                        </div>
                        <span class="text-xl font-bold text-gray-800">Portofolio</span>
                    </a>
                </div>
                
                <div class="hidden md:flex items-center space-x-8">
                    <a href="<?= base_url('/') ?>" class="nav-link text-gray-700 hover:text-purple-600 px-3 py-2 text-sm font-medium <?= (current_url() == base_url('/')) ? 'active text-purple-600' : '' ?>">
                        <i class="fas fa-home mr-2"></i>Beranda
                    </a>
                    <a href="<?= base_url('/biodata') ?>" class="nav-link text-gray-700 hover:text-purple-600 px-3 py-2 text-sm font-medium <?= (strpos(current_url(), 'biodata') !== false) ? 'active text-purple-600' : '' ?>">
                        <i class="fas fa-id-card mr-2"></i>Biodata
                    </a>
                    <a href="<?= base_url('/pendidikan') ?>" class="nav-link text-gray-700 hover:text-purple-600 px-3 py-2 text-sm font-medium <?= (strpos(current_url(), 'pendidikan') !== false) ? 'active text-purple-600' : '' ?>">
                        <i class="fas fa-graduation-cap mr-2"></i>Pendidikan
                    </a>
                    <a href="<?= base_url('/aktivitas') ?>" class="nav-link text-gray-700 hover:text-purple-600 px-3 py-2 text-sm font-medium <?= (strpos(current_url(), 'aktivitas') !== false) ? 'active text-purple-600' : '' ?>">
                        <i class="fas fa-calendar-alt mr-2"></i>Aktivitas
                    </a>
                    <a href="<?= base_url('/admin') ?>" class="btn-purple text-white px-4 py-2 rounded-lg text-sm font-medium">
                        <i class="fas fa-cog mr-2"></i>Admin
                    </a>
                </div>
                
                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center">
                    <button type="button" class="mobile-menu-button text-gray-500 hover:text-gray-600 focus:outline-none focus:text-gray-600" aria-label="toggle menu">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile menu -->
        <div class="mobile-menu hidden md:hidden">
            <div class="px-2 pt-2 pb-3 space-y-1 sm:px-3 bg-white border-t">
                <a href="<?= base_url('/') ?>" class="block px-3 py-2 text-gray-700 hover:text-purple-600 <?= (current_url() == base_url('/')) ? 'text-purple-600' : '' ?>">
                    <i class="fas fa-home mr-2"></i>Beranda
                </a>
                <a href="<?= base_url('/biodata') ?>" class="block px-3 py-2 text-gray-700 hover:text-purple-600 <?= (strpos(current_url(), 'biodata') !== false) ? 'text-purple-600' : '' ?>">
                    <i class="fas fa-id-card mr-2"></i>Biodata
                </a>
                <a href="<?= base_url('/pendidikan') ?>" class="block px-3 py-2 text-gray-700 hover:text-purple-600 <?= (strpos(current_url(), 'pendidikan') !== false) ? 'text-purple-600' : '' ?>">
                    <i class="fas fa-graduation-cap mr-2"></i>Pendidikan
                </a>
                <a href="<?= base_url('/aktivitas') ?>" class="block px-3 py-2 text-gray-700 hover:text-purple-600 <?= (strpos(current_url(), 'aktivitas') !== false) ? 'text-purple-600' : '' ?>">
                    <i class="fas fa-calendar-alt mr-2"></i>Aktivitas
                </a>
                <a href="<?= base_url('/admin') ?>" class="block px-3 py-2 text-purple-600 font-medium">
                    <i class="fas fa-cog mr-2"></i>Admin
                </a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="animate-fade-in">
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white mt-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <div class="text-center">
                <div class="flex justify-center items-center space-x-2 mb-4">
                    <div class="w-8 h-8 gradient-purple rounded-lg flex items-center justify-center">
                        <i class="fas fa-user text-white text-sm"></i>
                    </div>
                    <span class="text-xl font-bold">Portofolio</span>
                </div>
                <p class="text-gray-400 mb-4">Aplikasi Portofolio dengan CodeIgniter 4</p>
                <div class="flex justify-center space-x-6">
                    <a href="#" class="text-gray-400 hover:text-purple-400 transition-colors">
                        <i class="fab fa-github text-xl"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-purple-400 transition-colors">
                        <i class="fab fa-linkedin text-xl"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-purple-400 transition-colors">
                        <i class="fab fa-instagram text-xl"></i>
                    </a>
                </div>
                <div class="mt-6 pt-6 border-t border-gray-700">
                    <p class="text-gray-400 text-sm">&copy; 2024 Portofolio. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- JavaScript -->
    <script>
        // Mobile menu toggle
        document.querySelector('.mobile-menu-button').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.toggle('hidden');
        });

        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });

        // Add loading animation
        window.addEventListener('load', function() {
            document.body.classList.add('loaded');
        });
    </script>
</body>
</html>