<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Portfolio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        purple: {
                            50: '#f5f3ff',
                            100: '#ede9fe',
                            200: '#ddd6fe',
                            300: '#c4b5fd',
                            400: '#a78bfa',
                            500: '#8b5cf6',
                            600: '#7c3aed',
                            700: '#6d28d9',
                            800: '#5b21b6',
                            900: '#4c1d95',
                        }
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-50 text-gray-800 antialiased">

<div class="flex h-screen overflow-hidden">
    <!-- Sidebar -->
    <aside class="w-64 bg-purple-900 text-white flex-shrink-0 hidden md:block transition-all duration-300">
        <div class="p-6 flex items-center justify-center border-b border-purple-800">
            <h1 class="text-2xl font-bold tracking-wider hover:text-purple-200 transition-colors cursor-pointer">
                <i class="fa-solid fa-code mr-2"></i>Admin
            </h1>
        </div>
        <nav class="mt-6 px-4 space-y-2">
            <a href="/admin/dashboard" class="flex items-center px-4 py-3 rounded-lg hover:bg-purple-800 transition-all duration-200 group <?= current_url() == base_url('admin/dashboard') ? 'bg-purple-800 ring-2 ring-purple-600' : '' ?>">
                <i class="fa-solid fa-gauge-high w-6 text-center group-hover:scale-110 transition-transform"></i>
                <span class="ml-3 font-medium">Dashboard</span>
            </a>
            <a href="/admin/biodata" class="flex items-center px-4 py-3 rounded-lg hover:bg-purple-800 transition-all duration-200 group <?= strpos(current_url(), 'admin/biodata') !== false ? 'bg-purple-800 ring-2 ring-purple-600' : '' ?>">
                <i class="fa-solid fa-user-tie w-6 text-center group-hover:scale-110 transition-transform"></i>
                <span class="ml-3 font-medium">Biodata / CV</span>
            </a>
            <a href="/admin/education" class="flex items-center px-4 py-3 rounded-lg hover:bg-purple-800 transition-all duration-200 group <?= strpos(current_url(), 'admin/education') !== false ? 'bg-purple-800 ring-2 ring-purple-600' : '' ?>">
                <i class="fa-solid fa-graduation-cap w-6 text-center group-hover:scale-110 transition-transform"></i>
                <span class="ml-3 font-medium">Pendidikan</span>
            </a>
            <a href="/admin/activity" class="flex items-center px-4 py-3 rounded-lg hover:bg-purple-800 transition-all duration-200 group <?= strpos(current_url(), 'admin/activity') !== false ? 'bg-purple-800 ring-2 ring-purple-600' : '' ?>">
                <i class="fa-solid fa-calendar-check w-6 text-center group-hover:scale-110 transition-transform"></i>
                <span class="ml-3 font-medium">Aktivitas</span>
            </a>
            <div class="pt-6 mt-6 border-t border-purple-800 space-y-2">
                <a href="/" target="_blank" class="flex items-center px-4 py-3 rounded-lg hover:bg-purple-800 text-purple-200 hover:text-white transition-all duration-200">
                    <i class="fa-solid fa-external-link-alt w-6 text-center"></i>
                    <span class="ml-3 font-medium">Lihat Situs</span>
                </a>
                <a href="/logout" class="flex items-center px-4 py-3 rounded-lg hover:bg-red-800 text-purple-200 hover:text-white transition-all duration-200">
                    <i class="fa-solid fa-sign-out-alt w-6 text-center"></i>
                    <span class="ml-3 font-medium">Keluar</span>
                </a>
            </div>
        </nav>
    </aside>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col h-full overflow-hidden relative">
        <!-- Header -->
        <header class="h-16 bg-white shadow-sm flex items-center justify-between px-8 z-10 w-full">
            <div class="flex items-center">
                <button class="md:hidden text-gray-500 hover:text-purple-700 focus:outline-none">
                    <i class="fa-solid fa-bars text-xl"></i>
                </button>
                <h2 class="text-xl font-semibold text-gray-800 ml-4 md:ml-0"><?= $title ?? 'Admin Panel' ?></h2>
            </div>
            <div class="flex items-center space-x-4">
                <div class="flex items-center space-x-2">
                   <div class="h-8 w-8 rounded-full bg-purple-100 flex items-center justify-center text-purple-700 font-bold border border-purple-200">A</div>
                   <span class="text-sm font-medium text-gray-700">Administrator</span>
                </div>
            </div>
        </header>

        <!-- Content Scroll -->
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-8">
            <?= $this->renderSection('content') ?>
        </main>
    </div>
</div>

</body>
</html>
