<?= $this->extend('layout/public') ?>

<?= $this->section('content') ?>

<div class="text-center py-20">
    <div class="inline-block p-1 rounded-full bg-gradient-to-tr from-purple-500 to-indigo-500 mb-6">
        <?php if(!empty($biodata['foto'])): ?>
            <img src="/uploads/photos/<?= esc($biodata['foto']) ?>" alt="Profile" class="h-40 w-40 rounded-full border-4 border-white object-cover">
        <?php else: ?>
            <div class="h-40 w-40 rounded-full border-4 border-white bg-white flex items-center justify-center text-purple-200">
                <i class="fa-solid fa-user text-6xl"></i>
            </div>
        <?php endif; ?>
    </div>
    
    <h1 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4 tracking-tight">
        Halo, Saya <span class="text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-indigo-600"><?= esc($biodata['nama'] ?? 'John Doe') ?></span>
    </h1>
    
    <p class="text-xl text-gray-600 max-w-2xl mx-auto mb-10 leading-relaxed">
        <?= esc($biodata['deskripsi'] ?? 'Selamat datang di portofolio profesional saya. Saya adalah pengembang yang bersemangat.') ?>
    </p>

    <div class="flex flex-col sm:flex-row justify-center gap-4">
        <a href="/biodata" class="px-8 py-3 rounded-full bg-purple-600 text-white font-semibold hover:bg-purple-700 transition-all transform hover:scale-105 shadow-lg shadow-purple-200">
            Lihat Profil Saya
        </a>
        <a href="/activities" class="px-8 py-3 rounded-full bg-white text-purple-600 border border-purple-200 font-semibold hover:bg-purple-50 transition-all transform hover:scale-105">
            Lihat Aktivitas
        </a>
    </div>
</div>

<div class="grid grid-cols-1 md:grid-cols-3 gap-8 py-12">
    <div class="bg-white p-8 rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group border border-purple-50">
        <div class="w-14 h-14 bg-purple-100 rounded-xl flex items-center justify-center text-purple-600 mb-6 group-hover:bg-purple-600 group-hover:text-white transition-colors">
            <i class="fa-solid fa-code text-2xl"></i>
        </div>
        <h3 class="text-xl font-bold text-gray-900 mb-3">Biodata</h3>
        <p class="text-gray-500 leading-relaxed">Profil profesional mendetail, keahlian, dan informasi pribadi.</p>
        <a href="/biodata" class="inline-flex items-center mt-4 text-purple-600 font-medium hover:text-purple-700">
            Selengkapnya <i class="fa-solid fa-arrow-right ml-2 text-sm"></i>
        </a>
    </div>

    <div class="bg-white p-8 rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group border border-purple-50">
        <div class="w-14 h-14 bg-indigo-100 rounded-xl flex items-center justify-center text-indigo-600 mb-6 group-hover:bg-indigo-600 group-hover:text-white transition-colors">
            <i class="fa-solid fa-graduation-cap text-2xl"></i>
        </div>
        <h3 class="text-xl font-bold text-gray-900 mb-3">Pendidikan</h3>
        <p class="text-gray-500 leading-relaxed">Latar belakang akademis, gelar, dan pencapaian pendidikan.</p>
        <a href="/education" class="inline-flex items-center mt-4 text-indigo-600 font-medium hover:text-indigo-700">
            Lihat Riwayat <i class="fa-solid fa-arrow-right ml-2 text-sm"></i>
        </a>
    </div>

    <div class="bg-white p-8 rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 group border border-purple-50">
        <div class="w-14 h-14 bg-pink-100 rounded-xl flex items-center justify-center text-pink-600 mb-6 group-hover:bg-pink-600 group-hover:text-white transition-colors">
            <i class="fa-solid fa-camera text-2xl"></i>
        </div>
        <h3 class="text-xl font-bold text-gray-900 mb-3">Aktivitas</h3>
        <p class="text-gray-500 leading-relaxed">Catatan harian, galeri foto, dan pembaruan video dari pekerjaan saya.</p>
        <a href="/activities" class="inline-flex items-center mt-4 text-pink-600 font-medium hover:text-pink-700">
            Telusuri Galeri <i class="fa-solid fa-arrow-right ml-2 text-sm"></i>
        </a>
    </div>
</div>

<?= $this->endSection() ?>
