<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="max-w-4xl mx-auto">
    <div class="flex items-center mb-6">
        <a href="/admin/activity" class="text-gray-500 hover:text-purple-700 mr-4 transition-colors">
            <i class="fa-solid fa-arrow-left"></i>
        </a>
        <h1 class="text-2xl font-bold text-gray-800">Edit Aktivitas</h1>
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-8">
        <form action="/admin/activity/update/<?= $activity['id'] ?>" method="post" enctype="multipart/form-data" class="space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Tanggal</label>
                    <input type="date" name="tanggal" value="<?= esc($activity['tanggal']) ?>" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent outline-none">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Jam</label>
                    <input type="time" name="jam" value="<?= esc($activity['jam']) ?>" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent outline-none">
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Nama Aktivitas</label>
                <input type="text" name="nama_aktivitas" value="<?= esc($activity['nama_aktivitas']) ?>" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent outline-none">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Kategori</label>
                <input type="text" name="kategori" value="<?= esc($activity['kategori']) ?>" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent outline-none">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Deskripsi</label>
                <textarea name="deskripsi" rows="3" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent outline-none"><?= esc($activity['deskripsi']) ?></textarea>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Foto (Opsional)</label>
                    <?php if($activity['foto']): ?>
                        <div class="mb-2">
                            <img src="/uploads/photos/<?= esc($activity['foto']) ?>" alt="Current Photo" class="h-20 w-auto rounded border">
                        </div>
                    <?php endif; ?>
                    <input type="file" name="foto" class="w-full px-4 py-2 border rounded-lg text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Video (Opsional)</label>
                    <?php if($activity['video']): ?>
                        <div class="mb-2 text-sm text-gray-600">
                            Saat ini: <?= esc($activity['video']) ?>
                        </div>
                    <?php endif; ?>
                    <input type="file" name="video" class="w-full px-4 py-2 border rounded-lg text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                </div>
            </div>

            <div class="flex justify-end pt-4">
                <button type="submit" class="px-6 py-2 bg-purple-600 text-white font-medium rounded-lg hover:bg-purple-700 transition-colors shadow-sm">
                    Perbarui Aktivitas
                </button>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
