<?= $this->extend('layout/public') ?>

<?= $this->section('content') ?>

<div class="mb-10 text-center">
    <h1 class="text-3xl font-bold text-gray-900 mb-4">Aktivitas Harian</h1>
    <p class="text-gray-500 max-w-2xl mx-auto">Sekilas tentang kehidupan profesional, proyek, dan perjalanan belajar saya.</p>
</div>

<!-- Controls -->
<div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 mb-8 flex flex-col md:flex-row justify-between items-center gap-4">
    <!-- Search -->
    <form action="" method="get" class="w-full md:w-auto flex-grow max-w-lg relative">
        <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari aktivitas atau kategori..." class="w-full pl-10 pr-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 text-sm">
        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
            <i class="fa-solid fa-search"></i>
        </div>
        <?php if($sort): ?><input type="hidden" name="sort" value="<?= esc($sort) ?>"><?php endif; ?>
        <?php if($order): ?><input type="hidden" name="order" value="<?= esc($order) ?>"><?php endif; ?>
    </form>
    
    <!-- Sort -->
    <div class="flex items-center space-x-2 flex-shrink-0">
        <span class="text-sm text-gray-500">Urutkan:</span>
        <a href="?sort=tanggal&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= $search ?>" class="px-3 py-2 text-sm border rounded-lg hover:bg-gray-50 transition-colors <?= $sort == 'tanggal' ? 'bg-purple-50 text-purple-700 border-purple-200' : 'bg-white' ?>">
            Tanggal <?php if($sort == 'tanggal'): ?><i class="fa-solid fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i><?php endif; ?>
        </a>
        <a href="?sort=kategori&order=<?= $order == 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= $search ?>" class="px-3 py-2 text-sm border rounded-lg hover:bg-gray-50 transition-colors <?= $sort == 'kategori' ? 'bg-purple-50 text-purple-700 border-purple-200' : 'bg-white' ?>">
            Kategori <?php if($sort == 'kategori'): ?><i class="fa-solid fa-sort-<?= $order == 'ASC' ? 'up' : 'down' ?> ml-1"></i><?php endif; ?>
        </a>
    </div>
</div>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
    <?php foreach ($activities as $item) : ?>
    <div class="bg-white rounded-2xl shadow-sm hover:shadow-2xl transition-all duration-300 overflow-hidden transform hover:-translate-y-2 border border-purple-50 flex flex-col h-full group">
        <!-- Media -->
        <div class="relative h-48 bg-gray-100 overflow-hidden">
            <?php if(!empty($item['foto'])): ?>
                <img src="/uploads/photos/<?= esc($item['foto']) ?>" alt="Activity Photo" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110">
            <?php elseif(!empty($item['video'])): ?>
                <video class="w-full h-full object-cover">
                    <source src="/uploads/videos/<?= esc($item['video']) ?>" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
                <div class="absolute inset-0 flex items-center justify-center bg-black bg-opacity-30">
                    <i class="fa-solid fa-play-circle text-white text-4xl opacity-80"></i>
                </div>
            <?php else: ?>
                <div class="w-full h-full flex items-center justify-center bg-gradient-to-br from-purple-100 to-indigo-100 text-purple-300">
                    <i class="fa-regular fa-image text-5xl"></i>
                </div>
            <?php endif; ?>
            
            <div class="absolute top-4 right-4 bg-white/90 backdrop-blur-sm px-3 py-1 rounded-full text-xs font-semibold text-purple-600 shadow-sm">
                <?= esc($item['kategori'] ?? 'Umum') ?>
            </div>
        </div>

        <!-- Content -->
        <div class="p-6 flex-grow flex flex-col">
            <div class="flex items-center text-xs text-gray-500 mb-3 space-x-3">
                <span class="flex items-center"><i class="fa-solid fa-calendar mr-1"></i> <?= esc($item['tanggal']) ?></span>
                <span class="flex items-center"><i class="fa-solid fa-clock mr-1"></i> <?= substr($item['jam'], 0, 5) ?></span>
            </div>
            
            <h3 class="text-xl font-bold text-gray-900 mb-3 line-clamp-2"><?= esc($item['nama_aktivitas']) ?></h3>
            
            <p class="text-gray-600 text-sm leading-relaxed mb-4 flex-grow">
                <?= esc($item['deskripsi']) ?>
            </p>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php if(empty($activities)): ?>
    <div class="text-center py-20 bg-white rounded-xl shadow-sm">
        <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gray-100 mb-4 text-gray-400">
            <i class="fa-solid fa-camera text-2xl"></i>
        </div>
        <h3 class="text-lg font-medium text-gray-900">Tidak ada aktivitas ditemukan</h3>
        <p class="text-gray-500 mt-1">Cek kembali nanti untuk pembaruan atau sesuaikan pencarian Anda.</p>
    </div>
<?php endif; ?>

<div class="mt-12 flex justify-center">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>
