<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateRiwayatPendidikanTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'jenjang' => [
                'type' => 'ENUM',
                'constraint' => ['SD', 'SMP', 'SMA', 'D3', 'S1', 'S2', 'S3'],
            ],
            'nama_sekolah' => [
                'type' => 'VARCHAR',
                'constraint' => 200,
            ],
            'jurusan' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => true,
            ],
            'tahun_masuk' => [
                'type' => 'YEAR',
            ],
            'tahun_lulus' => [
                'type' => 'YEAR',
                'null' => true,
            ],
            'nilai_akhir' => [
                'type' => 'VARCHAR',
                'constraint' => 10,
                'null' => true,
            ],
            'prestasi' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'alamat_sekolah' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'null' => true,
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->createTable('riwayat_pendidikan');
    }

    public function down()
    {
        $this->forge->dropTable('riwayat_pendidikan');
    }
}
