<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>
<!-- Hero Section with Morphing Blob -->
<section class="hero">
    <div class="hero-content">
        <div class="hero-text">
            <div class="hero-badge">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"></circle>
                    <polyline points="12 6 12 12 16 14"></polyline>
                </svg>
                Tersedia untuk Proyek
            </div>
            
            <h1 class="hero-title"><?= esc($biodata['full_name'] ?? 'Portfolio') ?></h1>
            
            <p class="hero-description"><?= esc($biodata['headline'] ?? 'Full-Stack Web Developer') ?></p>
            
            <?php if (!empty($biodata['skills_array'])): ?>
            <div class="hero-skills">
                <?php foreach (array_slice($biodata['skills_array'], 0, 5) as $skill): ?>
                <span class="skill-tag">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                    <?= esc($skill) ?>
                </span>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
            
            <div class="hero-buttons">
                <a href="<?= base_url('aktivitas') ?>" class="btn btn-primary btn-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                        <polyline points="2 17 12 22 22 17"></polyline>
                        <polyline points="2 12 12 17 22 12"></polyline>
                    </svg>
                    Lihat Projek
                </a>
                <a href="<?= base_url('about') ?>" class="btn btn-secondary btn-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                    Tentang Saya
                </a>
            </div>
        </div>
        
        <div class="hero-visual">
            <!-- 3D Container will be populated by Three.js -->
            <div class="hero-3d-container" id="hero3d"></div>
        </div>
    </div>
</section>

<!-- Latest Activities Section -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <div class="section-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                    <polyline points="2 17 12 22 22 17"></polyline>
                    <polyline points="2 12 12 17 22 12"></polyline>
                </svg>
            </div>
            <h2 class="section-title">Aktivitas Terbaru</h2>
            <p class="section-subtitle">Proyek dan kegiatan yang sedang saya kerjakan</p>
        </div>
        
        <?php if (!empty($activities)): ?>
        <div class="grid-3">
            <?php foreach ($activities as $activity): ?>
            <a href="<?= base_url('aktivitas/' . $activity['slug']) ?>" class="card">
                <?php if (!empty($activity['cover_image'])): ?>
                <img src="<?= base_url('uploads/' . $activity['cover_image']) ?>" alt="<?= esc($activity['title']) ?>" class="card-image">
                <?php else: ?>
                <div class="card-image" style="display: flex; align-items: center; justify-content: center;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" style="color: var(--color-text-muted);">
                        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                        <circle cx="8.5" cy="8.5" r="1.5"></circle>
                        <polyline points="21 15 16 10 5 21"></polyline>
                    </svg>
                </div>
                <?php endif; ?>
                <div class="card-body">
                    <span class="tag"><?= esc($activity['category']) ?></span>
                    <h3 class="card-title" style="margin-top: var(--space-3);"><?= esc($activity['title']) ?></h3>
                    <p class="card-text"><?= esc(character_limiter($activity['description'], 100)) ?></p>
                    <div class="card-meta">
                        <span style="display: flex; align-items: center; gap: var(--space-2);">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                <line x1="16" y1="2" x2="16" y2="6"></line>
                                <line x1="8" y1="2" x2="8" y2="6"></line>
                                <line x1="3" y1="10" x2="21" y2="10"></line>
                            </svg>
                            <?= date('d M Y', strtotime($activity['activity_date'] ?? $activity['created_at'])) ?>
                        </span>
                    </div>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center" style="margin-top: var(--space-8);">
            <a href="<?= base_url('aktivitas') ?>" class="btn btn-secondary">
                Lihat Semua Aktivitas
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                    <polyline points="12 5 19 12 12 19"></polyline>
                </svg>
            </a>
        </div>
        <?php else: ?>
        <div class="empty-state">
            <div class="empty-state-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                    <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                    <polyline points="2 17 12 22 22 17"></polyline>
                    <polyline points="2 12 12 17 22 12"></polyline>
                </svg>
            </div>
            <h3 class="empty-state-title">Belum Ada Aktivitas</h3>
            <p class="empty-state-text">Aktivitas akan ditampilkan di sini</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Education Section -->
<?php if (!empty($educations)): ?>
<section class="section">
    <div class="container">
        <div class="section-header">
            <div class="section-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                    <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                </svg>
            </div>
            <h2 class="section-title">Pendidikan Berlangsung</h2>
            <p class="section-subtitle">Perjalanan akademis saya saat ini</p>
        </div>
        
        <div class="grid-2">
            <?php foreach ($educations as $edu): ?>
            <div class="card">
                <div class="card-body">
                    <div style="display: flex; align-items: flex-start; gap: var(--space-4);">
                        <div style="width: 56px; height: 56px; background: var(--gradient-card); border: 1px solid var(--color-border); border-radius: var(--radius-xl); display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--color-primary);">
                                <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                                <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                            </svg>
                        </div>
                        <div style="flex: 1;">
                            <span class="tag"><?= esc($edu['degree']) ?></span>
                            <h3 class="card-title" style="margin-top: var(--space-2);"><?= esc($edu['institution']) ?></h3>
                            <p class="card-text" style="margin-bottom: var(--space-2);"><?= esc($edu['major']) ?></p>
                            <div class="card-meta">
                                <span style="display: flex; align-items: center; gap: var(--space-2);">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <polyline points="12 6 12 12 16 14"></polyline>
                                    </svg>
                                    <?= esc($edu['start_year']) ?> - Sekarang
                                </span>
                                <?php if (!empty($edu['gpa'])): ?>
                                <span style="display: flex; align-items: center; gap: var(--space-2);">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                                    </svg>
                                    IPK: <?= esc($edu['gpa']) ?>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CTA Section -->
<section class="section" style="background: var(--gradient-card); border-top: 1px solid var(--color-border); border-bottom: 1px solid var(--color-border);">
    <div class="container text-center">
        <div class="section-icon" style="background: var(--gradient-primary);">
            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                <polyline points="22,6 12,13 2,6"></polyline>
            </svg>
        </div>
        <h2 class="section-title">Tertarik Berkolaborasi?</h2>
        <p class="section-subtitle" style="margin-bottom: var(--space-8);">Mari diskusikan proyek Anda dan wujudkan ide menjadi kenyataan</p>
        <a href="<?= base_url('about') ?>" class="btn btn-primary btn-lg">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path>
            </svg>
            Hubungi Saya
        </a>
    </div>
</section>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script type="module" src="<?= base_url('assets/js/three/heroScene.js') ?>"></script>
<?= $this->endSection() ?>
