<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>
<!-- Page Header -->
<div class="page-header">
    <div class="page-icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
            <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
        </svg>
    </div>
    <h1 class="page-title">Pendidikan</h1>
    <p class="page-subtitle">Riwayat pendidikan dan sertifikasi profesional</p>
</div>

<section class="section" style="padding-top: 0;">
    <div class="container">
        <!-- Filter Bar -->
        <form action="<?= base_url('pendidikan') ?>" method="get" class="filter-bar">
            <div class="search-box">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="search-icon">
                    <circle cx="11" cy="11" r="8"></circle>
                    <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                </svg>
                <input type="text" name="q" placeholder="Cari pendidikan..." class="search-input" value="<?= esc($search ?? '') ?>">
            </div>
            
            <select name="degree" class="filter-select">
                <option value="">Semua Jenjang</option>
                <?php foreach ($degrees as $deg): ?>
                <option value="<?= esc($deg['degree']) ?>" <?= ($degree ?? '') === $deg['degree'] ? 'selected' : '' ?>>
                    <?= esc($deg['degree']) ?>
                </option>
                <?php endforeach; ?>
            </select>
            
            <button type="submit" class="btn btn-primary btn-sm">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="11" cy="11" r="8"></circle>
                    <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                </svg>
                Cari
            </button>
            
            <?php if (!empty($search) || !empty($degree)): ?>
            <a href="<?= base_url('pendidikan') ?>" class="btn btn-secondary btn-sm">Reset</a>
            <?php endif; ?>
        </form>
        
        <?php if (!empty($educations)): ?>
        <p class="results-info" style="color: var(--color-text-muted); text-align: center; margin-bottom: var(--space-6);">
            Menampilkan <?= count($educations) ?> dari <?= $total ?> pendidikan
        </p>
        
        <div class="grid-2">
            <?php foreach ($educations as $edu): ?>
            <div class="card">
                <div class="card-body">
                    <div style="display: flex; align-items: flex-start; gap: var(--space-4);">
                        <div style="width: 64px; height: 64px; background: var(--gradient-card); border: 1px solid var(--color-border); border-radius: var(--radius-xl); display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--color-primary);">
                                <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                                <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                            </svg>
                        </div>
                        <div style="flex: 1;">
                            <div style="display: flex; align-items: center; gap: var(--space-2); margin-bottom: var(--space-2);">
                                <span class="tag"><?= esc($edu['degree']) ?></span>
                                <span class="tag" style="background: <?= $edu['status'] === 'ongoing' ? 'rgba(139, 92, 246, 0.2)' : 'rgba(52, 211, 153, 0.2)' ?>; color: <?= $edu['status'] === 'ongoing' ? 'var(--color-primary-light)' : 'var(--color-success)' ?>;">
                                    <?= $edu['status'] === 'ongoing' ? 'Berlangsung' : 'Selesai' ?>
                                </span>
                            </div>
                            <h3 class="card-title" style="margin-top: 0;"><?= esc($edu['institution']) ?></h3>
                            <p class="card-text" style="margin-bottom: var(--space-2);"><?= esc($edu['major']) ?></p>
                            
                            <?php if (!empty($edu['description'])): ?>
                            <p class="card-text" style="font-size: 0.875rem;"><?= esc(character_limiter($edu['description'], 150)) ?></p>
                            <?php endif; ?>
                            
                            <div class="card-meta">
                                <span style="display: flex; align-items: center; gap: var(--space-2);">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <polyline points="12 6 12 12 16 14"></polyline>
                                    </svg>
                                    <?= esc($edu['start_year']) ?> - <?= $edu['end_year'] ? esc($edu['end_year']) : 'Sekarang' ?>
                                </span>
                                <?php if (!empty($edu['gpa'])): ?>
                                <span style="display: flex; align-items: center; gap: var(--space-2);">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                                    </svg>
                                    IPK: <?= esc($edu['gpa']) ?>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Pagination -->
        <div class="pagination">
            <?= $pager->links() ?>
        </div>
        <?php else: ?>
        <div class="empty-state">
            <div class="empty-state-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                    <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
                </svg>
            </div>
            <h3 class="empty-state-title">Tidak Ada Pendidikan</h3>
            <p class="empty-state-text">
                <?php if (!empty($search) || !empty($degree)): ?>
                Tidak ada pendidikan yang cocok dengan pencarian Anda
                <?php else: ?>
                Belum ada data pendidikan
                <?php endif; ?>
            </p>
            <?php if (!empty($search) || !empty($degree)): ?>
            <a href="<?= base_url('pendidikan') ?>" class="btn btn-primary" style="margin-top: var(--space-4);">Reset Filter</a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
