<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<!-- Stats Grid -->
<div class="stat-grid">
    <div class="stat-card">
        <div class="stat-icon blue">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"></path>
            </svg>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?= $totalActivities ?></div>
            <div class="stat-label">Total Aktivitas</div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon green">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <polyline points="20 6 9 17 4 12"></polyline>
            </svg>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?= $publishedActivities ?></div>
            <div class="stat-label">Aktivitas Published</div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon orange">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
            </svg>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?= $draftActivities ?></div>
            <div class="stat-label">Aktivitas Draft</div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon purple">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M22 10v6M2 10l10-5 10 5-10 5z"></path>
                <path d="M6 12v5c3 3 9 3 12 0v-5"></path>
            </svg>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?= $totalEducations ?></div>
            <div class="stat-label">Total Pendidikan</div>
        </div>
    </div>
</div>

<div class="grid-2" style="gap: var(--space-6);">
    <!-- Recent Activities -->
    <div class="admin-table-wrapper">
        <div class="admin-table-header">
            <h3 class="admin-table-title">Aktivitas Terbaru</h3>
            <a href="<?= base_url('admin/aktivitas') ?>" class="btn btn-sm btn-secondary">Lihat Semua</a>
        </div>
        
        <?php if (!empty($recentActivities)): ?>
        <table class="admin-table">
            <thead>
                <tr>
                    <th>Judul</th>
                    <th>Status</th>
                    <th>Tanggal</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recentActivities as $activity): ?>
                <tr>
                    <td>
                        <a href="<?= base_url('admin/aktivitas/edit/' . $activity['id']) ?>" style="color: var(--color-text-primary); font-weight: 500;">
                            <?= esc(character_limiter($activity['title'], 30)) ?>
                        </a>
                    </td>
                    <td>
                        <span class="status-badge <?= $activity['status'] ?>">
                            <?= ucfirst($activity['status']) ?>
                        </span>
                    </td>
                    <td style="color: var(--color-text-muted); font-size: 0.875rem;">
                        <?= $activity['activity_date'] ? date('d M Y', strtotime($activity['activity_date'])) : '-' ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
        <div class="empty-state" style="padding: var(--space-8);">
            <p class="text-muted">Belum ada aktivitas</p>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Biodata Summary -->
    <div class="admin-table-wrapper">
        <div class="admin-table-header">
            <h3 class="admin-table-title">Biodata</h3>
            <a href="<?= base_url('admin/biodata') ?>" class="btn btn-sm btn-primary">Edit</a>
        </div>
        
        <?php if ($biodata): ?>
        <div style="padding: var(--space-5);">
            <div style="display: flex; align-items: center; gap: var(--space-4); margin-bottom: var(--space-5);">
                <?php if (!empty($biodata['photo'])): ?>
                <img src="<?= base_url('uploads/' . $biodata['photo']) ?>" alt="Photo" style="width: 64px; height: 64px; border-radius: var(--radius-lg); object-fit: cover;">
                <?php else: ?>
                <div style="width: 64px; height: 64px; border-radius: var(--radius-lg); background: var(--color-primary-light); display: flex; align-items: center; justify-content: center; color: var(--color-primary);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                </div>
                <?php endif; ?>
                <div>
                    <h4 style="margin: 0 0 var(--space-1);"><?= esc($biodata['full_name']) ?></h4>
                    <p style="color: var(--color-primary); margin: 0; font-size: 0.875rem;"><?= esc($biodata['headline']) ?></p>
                </div>
            </div>
            
            <div style="display: grid; gap: var(--space-3); font-size: 0.9375rem;">
                <div style="display: flex; gap: var(--space-3); color: var(--color-text-secondary);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                        <polyline points="22,6 12,13 2,6"></polyline>
                    </svg>
                    <?= esc($biodata['email_public']) ?>
                </div>
                <?php if (!empty($biodata['location'])): ?>
                <div style="display: flex; gap: var(--space-3); color: var(--color-text-secondary);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                        <circle cx="12" cy="10" r="3"></circle>
                    </svg>
                    <?= esc($biodata['location']) ?>
                </div>
                <?php endif; ?>
            </div>
            
            <?php if (!empty($biodata['skills_array'])): ?>
            <div style="margin-top: var(--space-5);">
                <div class="tags">
                    <?php foreach (array_slice($biodata['skills_array'], 0, 6) as $skill): ?>
                    <span class="tag"><?= esc($skill) ?></span>
                    <?php endforeach; ?>
                    <?php if (count($biodata['skills_array']) > 6): ?>
                    <span class="tag">+<?= count($biodata['skills_array']) - 6 ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php else: ?>
        <div class="empty-state" style="padding: var(--space-8);">
            <p class="text-muted">Biodata belum diisi</p>
            <a href="<?= base_url('admin/biodata') ?>" class="btn btn-primary btn-sm" style="margin-top: var(--space-4);">Isi Sekarang</a>
        </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>
