<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="admin-form-card">
    <form action="<?= base_url('admin/biodata') ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="form-row">
            <div class="form-group">
                <label for="full_name" class="form-label">Nama Lengkap *</label>
                <input type="text" id="full_name" name="full_name" class="form-control" value="<?= old('full_name', $biodata['full_name'] ?? '') ?>" required>
            </div>
            
            <div class="form-group">
                <label for="headline" class="form-label">Headline *</label>
                <input type="text" id="headline" name="headline" class="form-control" value="<?= old('headline', $biodata['headline'] ?? '') ?>" placeholder="Full-Stack Web Developer" required>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="email_public" class="form-label">Email Publik *</label>
                <input type="email" id="email_public" name="email_public" class="form-control" value="<?= old('email_public', $biodata['email_public'] ?? '') ?>" required>
            </div>
            
            <div class="form-group">
                <label for="phone_public" class="form-label">Nomor Telepon</label>
                <input type="text" id="phone_public" name="phone_public" class="form-control" value="<?= old('phone_public', $biodata['phone_public'] ?? '') ?>" placeholder="+62 812 xxxx xxxx">
            </div>
        </div>
        
        <div class="form-group">
            <label for="location" class="form-label">Lokasi</label>
            <input type="text" id="location" name="location" class="form-control" value="<?= old('location', $biodata['location'] ?? '') ?>" placeholder="Jakarta, Indonesia">
        </div>
        
        <div class="form-group">
            <label for="about" class="form-label">Tentang Saya</label>
            <textarea id="about" name="about" class="form-control" rows="5" placeholder="Ceritakan tentang diri Anda..."><?= old('about', $biodata['about'] ?? '') ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="skills" class="form-label">Skills (pisahkan dengan koma)</label>
            <input type="text" id="skills" name="skills" class="form-control" value="<?= old('skills', implode(', ', $biodata['skills_array'] ?? [])) ?>" placeholder="PHP, Laravel, JavaScript, Vue.js">
            <small style="color: var(--color-text-muted);">Contoh: PHP, Laravel, JavaScript, Vue.js, MySQL</small>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="linkedin_url" class="form-label">LinkedIn URL</label>
                <input type="url" id="linkedin_url" name="linkedin_url" class="form-control" value="<?= old('linkedin_url', $biodata['linkedin_url'] ?? '') ?>" placeholder="https://linkedin.com/in/username">
            </div>
            
            <div class="form-group">
                <label for="github_url" class="form-label">GitHub URL</label>
                <input type="url" id="github_url" name="github_url" class="form-control" value="<?= old('github_url', $biodata['github_url'] ?? '') ?>" placeholder="https://github.com/username">
            </div>
        </div>
        
        <div class="form-group">
            <label for="portfolio_url" class="form-label">Portfolio URL</label>
            <input type="url" id="portfolio_url" name="portfolio_url" class="form-control" value="<?= old('portfolio_url', $biodata['portfolio_url'] ?? '') ?>" placeholder="https://yourportfolio.com">
        </div>
        
        <div class="form-group">
            <label class="form-label">Foto Profil</label>
            <div class="file-upload">
                <input type="file" name="photo" accept="image/jpeg,image/png,image/webp">
                <div class="file-upload-label">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="17 8 12 3 7 8"></polyline>
                        <line x1="12" y1="3" x2="12" y2="15"></line>
                    </svg>
                    Klik untuk upload foto (Max 2MB)
                </div>
            </div>
            <?php if (!empty($biodata['photo'])): ?>
            <div class="current-image">
                <img src="<?= base_url('uploads/' . $biodata['photo']) ?>" alt="Current photo">
                <span style="color: var(--color-text-muted); font-size: 0.875rem;">Foto saat ini</span>
            </div>
            <?php endif; ?>
        </div>
        
        <div style="display: flex; gap: var(--space-4); margin-top: var(--space-6);">
            <button type="submit" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                    <polyline points="17 21 17 13 7 13 7 21"></polyline>
                    <polyline points="7 3 7 8 15 8"></polyline>
                </svg>
                Simpan Perubahan
            </button>
            <a href="<?= base_url('admin') ?>" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>
