<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="admin-form-card">
    <form action="<?= $activity ? base_url('admin/aktivitas/update/' . $activity['id']) : base_url('admin/aktivitas/store') ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="form-group">
            <label for="title" class="form-label">Judul *</label>
            <input type="text" id="title" name="title" class="form-control" value="<?= old('title', $activity['title'] ?? '') ?>" required>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="category" class="form-label">Kategori *</label>
                <select id="category" name="category" class="form-control" required>
                    <option value="">Pilih Kategori</option>
                    <option value="Project" <?= old('category', $activity['category'] ?? '') === 'Project' ? 'selected' : '' ?>>Project</option>
                    <option value="Campus" <?= old('category', $activity['category'] ?? '') === 'Campus' ? 'selected' : '' ?>>Campus</option>
                    <option value="Freelance" <?= old('category', $activity['category'] ?? '') === 'Freelance' ? 'selected' : '' ?>>Freelance</option>
                </select>
            </div>
            
            <div class="form-group">
                <label for="activity_date" class="form-label">Tanggal Aktivitas</label>
                <input type="date" id="activity_date" name="activity_date" class="form-control" value="<?= old('activity_date', $activity['activity_date'] ?? '') ?>">
            </div>
        </div>
        
        <div class="form-group">
            <label for="status" class="form-label">Status *</label>
            <select id="status" name="status" class="form-control" required>
                <option value="draft" <?= old('status', $activity['status'] ?? 'draft') === 'draft' ? 'selected' : '' ?>>Draft</option>
                <option value="published" <?= old('status', $activity['status'] ?? '') === 'published' ? 'selected' : '' ?>>Published</option>
            </select>
        </div>
        
        <div class="form-group">
            <label for="description" class="form-label">Deskripsi</label>
            <textarea id="description" name="description" class="form-control" rows="6" placeholder="Jelaskan detail aktivitas..."><?= old('description', $activity['description'] ?? '') ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="tags" class="form-label">Tags (pisahkan dengan koma)</label>
            <input type="text" id="tags" name="tags" class="form-control" value="<?= old('tags', isset($activity['tags_array']) ? implode(', ', $activity['tags_array']) : '') ?>" placeholder="PHP, Laravel, MySQL">
        </div>
        
        <div class="form-group">
            <label class="form-label">Cover Image</label>
            <div class="file-upload">
                <input type="file" name="cover_image" accept="image/jpeg,image/png,image/webp">
                <div class="file-upload-label">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                        <circle cx="8.5" cy="8.5" r="1.5"></circle>
                        <polyline points="21 15 16 10 5 21"></polyline>
                    </svg>
                    Klik untuk upload cover (Max 4MB)
                </div>
            </div>
            <?php if (!empty($activity['cover_image'])): ?>
            <div class="current-image">
                <img src="<?= base_url('uploads/' . $activity['cover_image']) ?>" alt="Current cover">
                <span style="color: var(--color-text-muted); font-size: 0.875rem;">Cover saat ini</span>
            </div>
            <?php endif; ?>
        </div>
        
        <div style="display: flex; gap: var(--space-4); margin-top: var(--space-6);">
            <button type="submit" class="btn btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                    <polyline points="17 21 17 13 7 13 7 21"></polyline>
                    <polyline points="7 3 7 8 15 8"></polyline>
                </svg>
                <?= $activity ? 'Update' : 'Simpan' ?>
            </button>
            <a href="<?= base_url('admin/aktivitas') ?>" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>
