<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>
<article class="section">
    <div class="container" style="max-width: 800px;">
        <!-- Breadcrumb -->
        <nav style="margin-bottom: var(--space-6); font-size: 0.875rem;">
            <a href="<?= base_url('aktivitas') ?>" style="color: var(--color-text-muted);">Aktivitas</a>
            <span style="color: var(--color-text-muted);"> / </span>
            <span style="color: var(--color-text-primary);"><?= esc($activity['title']) ?></span>
        </nav>
        
        <!-- Cover Image -->
        <?php if (!empty($activity['cover_image'])): ?>
        <img src="<?= base_url('uploads/' . $activity['cover_image']) ?>" alt="<?= esc($activity['title']) ?>" class="detail-cover">
        <?php endif; ?>
        
        <!-- Header -->
        <div class="detail-header">
            <div class="detail-meta">
                <span class="tag tag-primary"><?= esc($activity['category']) ?></span>
                <span class="detail-meta-item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                        <line x1="16" y1="2" x2="16" y2="6"></line>
                        <line x1="8" y1="2" x2="8" y2="6"></line>
                        <line x1="3" y1="10" x2="21" y2="10"></line>
                    </svg>
                    <?= $activity['activity_date'] ? date('d F Y', strtotime($activity['activity_date'])) : 'Tanggal tidak tersedia' ?>
                </span>
            </div>
            
            <h1 style="font-size: 2.5rem; margin-bottom: var(--space-4);"><?= esc($activity['title']) ?></h1>
            
            <?php if (!empty($activity['tags_array'])): ?>
            <div class="tags">
                <?php foreach ($activity['tags_array'] as $tag): ?>
                <span class="tag"><?= esc($tag) ?></span>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Content -->
        <div class="detail-content">
            <?= nl2br(esc($activity['description'])) ?>
        </div>
        
        <!-- Share Buttons -->
        <div style="margin-top: var(--space-8); padding-top: var(--space-6); border-top: 1px solid var(--color-bg-tertiary);">
            <p style="color: var(--color-text-muted); font-size: 0.875rem; margin-bottom: var(--space-3);">Bagikan:</p>
            <div style="display: flex; gap: var(--space-3);">
                <a href="https://twitter.com/intent/tweet?url=<?= urlencode(current_url()) ?>&text=<?= urlencode($activity['title']) ?>" target="_blank" rel="noopener" class="btn btn-sm btn-secondary" aria-label="Bagikan ke Twitter">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z"></path>
                    </svg>
                </a>
                <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?= urlencode(current_url()) ?>&title=<?= urlencode($activity['title']) ?>" target="_blank" rel="noopener" class="btn btn-sm btn-secondary" aria-label="Bagikan ke LinkedIn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z"></path>
                        <rect x="2" y="9" width="4" height="12"></rect>
                        <circle cx="4" cy="4" r="2"></circle>
                    </svg>
                </a>
                <button onclick="navigator.clipboard.writeText('<?= current_url() ?>'); alert('Link disalin!');" class="btn btn-sm btn-secondary" aria-label="Salin link">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path>
                        <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>
</article>

<!-- Related Activities -->
<?php if (!empty($relatedActivities)): ?>
<section class="related-section section" style="background: var(--color-bg-primary); padding-top: var(--space-12);">
    <div class="container">
        <h2 style="text-align: center; margin-bottom: var(--space-8);">Aktivitas Terkait</h2>
        
        <div class="grid-3">
            <?php foreach ($relatedActivities as $related): ?>
            <article class="card card-spotlight">
                <?php if (!empty($related['cover_image'])): ?>
                <img src="<?= base_url('uploads/' . $related['cover_image']) ?>" alt="<?= esc($related['title']) ?>" class="card-image">
                <?php else: ?>
                <div class="card-image" style="display: flex; align-items: center; justify-content: center; background: var(--color-bg-tertiary);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" style="color: var(--color-text-muted);">
                        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                        <circle cx="8.5" cy="8.5" r="1.5"></circle>
                        <polyline points="21 15 16 10 5 21"></polyline>
                    </svg>
                </div>
                <?php endif; ?>
                
                <div class="card-body">
                    <h3 class="card-title">
                        <a href="<?= base_url('aktivitas/' . $related['slug']) ?>" style="color: inherit;">
                            <?= esc($related['title']) ?>
                        </a>
                    </h3>
                    <p class="card-text"><?= esc(character_limiter(strip_tags($related['description']), 80)) ?></p>
                </div>
            </article>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?= $this->endSection() ?>
