<?= $this->extend('layouts/public') ?>

<?= $this->section('content') ?>
<!-- Page Header -->
<div class="page-header">
    <div class="page-icon">
        <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
            <polyline points="2 17 12 22 22 17"></polyline>
            <polyline points="2 12 12 17 22 12"></polyline>
        </svg>
    </div>
    <h1 class="page-title">Aktivitas</h1>
    <p class="page-subtitle">Proyek, kegiatan, dan pengalaman yang telah saya kerjakan</p>
</div>

<section class="section" style="padding-top: 0;">
    <div class="container">
        <!-- Filter Bar -->
        <form action="<?= base_url('aktivitas') ?>" method="get" class="filter-bar">
            <div class="search-box">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="search-icon">
                    <circle cx="11" cy="11" r="8"></circle>
                    <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                </svg>
                <input type="text" name="q" placeholder="Cari aktivitas..." class="search-input" value="<?= esc($search ?? '') ?>">
            </div>
            
            <select name="category" class="filter-select">
                <option value="">Semua Kategori</option>
                <?php foreach ($categories as $cat): ?>
                <option value="<?= esc($cat['category']) ?>" <?= ($category ?? '') === $cat['category'] ? 'selected' : '' ?>>
                    <?= esc($cat['category']) ?>
                </option>
                <?php endforeach; ?>
            </select>
            
            <button type="submit" class="btn btn-primary btn-sm">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="11" cy="11" r="8"></circle>
                    <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                </svg>
                Cari
            </button>
            
            <?php if (!empty($search) || !empty($category)): ?>
            <a href="<?= base_url('aktivitas') ?>" class="btn btn-secondary btn-sm">Reset</a>
            <?php endif; ?>
        </form>
        
        <?php if (!empty($activities)): ?>
        <p class="results-info" style="color: var(--color-text-muted); text-align: center; margin-bottom: var(--space-6);">
            Menampilkan <?= count($activities) ?> dari <?= $total ?> aktivitas
        </p>
        
        <div class="grid-3">
            <?php foreach ($activities as $activity): ?>
            <a href="<?= base_url('aktivitas/' . $activity['slug']) ?>" class="card">
                <?php if (!empty($activity['cover_image'])): ?>
                <img src="<?= base_url('uploads/' . $activity['cover_image']) ?>" alt="<?= esc($activity['title']) ?>" class="card-image">
                <?php else: ?>
                <div class="card-image" style="display: flex; align-items: center; justify-content: center;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" style="color: var(--color-text-muted);">
                        <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                        <polyline points="2 17 12 22 22 17"></polyline>
                        <polyline points="2 12 12 17 22 12"></polyline>
                    </svg>
                </div>
                <?php endif; ?>
                <div class="card-body">
                    <span class="tag"><?= esc($activity['category']) ?></span>
                    <h3 class="card-title" style="margin-top: var(--space-3);"><?= esc($activity['title']) ?></h3>
                    <p class="card-text"><?= esc(character_limiter($activity['description'], 100)) ?></p>
                    <div class="card-meta">
                        <span style="display: flex; align-items: center; gap: var(--space-2);">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                <line x1="16" y1="2" x2="16" y2="6"></line>
                                <line x1="8" y1="2" x2="8" y2="6"></line>
                                <line x1="3" y1="10" x2="21" y2="10"></line>
                            </svg>
                            <?= date('d M Y', strtotime($activity['activity_date'] ?? $activity['created_at'])) ?>
                        </span>
                    </div>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        
        <!-- Pagination -->
        <div class="pagination">
            <?= $pager->links() ?>
        </div>
        <?php else: ?>
        <div class="empty-state">
            <div class="empty-state-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                    <polygon points="12 2 2 7 12 12 22 7 12 2"></polygon>
                    <polyline points="2 17 12 22 22 17"></polyline>
                    <polyline points="2 12 12 17 22 12"></polyline>
                </svg>
            </div>
            <h3 class="empty-state-title">Tidak Ada Aktivitas</h3>
            <p class="empty-state-text">
                <?php if (!empty($search) || !empty($category)): ?>
                Tidak ada aktivitas yang cocok dengan pencarian Anda
                <?php else: ?>
                Belum ada aktivitas yang dipublikasikan
                <?php endif; ?>
            </p>
            <?php if (!empty($search) || !empty($category)): ?>
            <a href="<?= base_url('aktivitas') ?>" class="btn btn-primary" style="margin-top: var(--space-4);">Reset Filter</a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
