<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEducations extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'institution' => [
                'type'       => 'VARCHAR',
                'constraint' => 200,
            ],
            'major' => [
                'type'       => 'VARCHAR',
                'constraint' => 150,
            ],
            'degree' => [
                'type'       => 'VARCHAR',
                'constraint' => 50,
            ],
            'start_year' => [
                'type'       => 'INT',
                'constraint' => 4,
            ],
            'end_year' => [
                'type'       => 'INT',
                'constraint' => 4,
                'null'       => true,
            ],
            'gpa' => [
                'type'       => 'DECIMAL',
                'constraint' => '3,2',
                'null'       => true,
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'status' => [
                'type'       => 'ENUM',
                'constraint' => ['ongoing', 'completed'],
                'default'    => 'ongoing',
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->addKey('institution');
        $this->forge->addKey('status');
        $this->forge->addKey('start_year');
        $this->forge->createTable('educations');
    }

    public function down()
    {
        $this->forge->dropTable('educations');
    }
}
