<?php

namespace App\Controllers;

class NotionController extends BaseController
{
    public function index()
    {
        $notionUrl = env('NOTION_PUBLIC_URL', '');
        
        if (empty($notionUrl)) {
            // Notion integration disabled
            $data = [
                'title'     => 'Updates',
                'enabled'   => false,
                'notionUrl' => null,
            ];
        } else {
            $data = [
                'title'     => 'Updates',
                'enabled'   => true,
                'notionUrl' => $notionUrl,
            ];
        }

        return view('pages/notion', $data);
    }
}
