<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\ActivityModel;
use App\Models\EducationModel;

class HomeController extends BaseController
{
    protected $biodataModel;
    protected $activityModel;
    protected $educationModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        $this->activityModel = new ActivityModel();
        $this->educationModel = new EducationModel();
    }

    public function index()
    {
        $biodata = $this->biodataModel->getBiodata();
        
        // Get latest published activities (3 for homepage)
        $latestActivities = $this->activityModel
            ->where('status', 'published')
            ->orderBy('activity_date', 'DESC')
            ->limit(3)
            ->findAll();

        // Parse tags for each activity
        foreach ($latestActivities as &$activity) {
            $activity['tags_array'] = json_decode($activity['tags'] ?? '[]', true) ?? [];
        }

        // Get ongoing education
        $ongoingEducation = $this->educationModel->getOngoing();

        $data = [
            'title'            => 'Home',
            'biodata'          => $biodata,
            'latestActivities' => $latestActivities,
            'ongoingEducation' => $ongoingEducation,
        ];

        return view('pages/home', $data);
    }
}
