<?php

namespace App\Controllers;

use App\Models\EducationModel;

class EducationController extends BaseController
{
    protected $educationModel;

    public function __construct()
    {
        $this->educationModel = new EducationModel();
    }

    /**
     * List educations with search, filter, and pagination
     */
    public function index()
    {
        $request = $this->request;
        
        // Get query parameters
        $search = $request->getGet('q');
        $degree = $request->getGet('degree');
        $page   = (int) ($request->getGet('page') ?? 1);

        // Get educations with pagination
        $educations = $this->educationModel->getPublicEducations($search, $degree, 6);

        // Get degrees for filter dropdown
        $degrees = $this->educationModel->getDegrees();

        $data = [
            'title'      => 'Pendidikan',
            'educations' => $educations,
            'pager'      => $this->educationModel->pager,
            'degrees'    => $degrees,
            'search'     => $search,
            'degree'     => $degree,
            'total'      => $this->educationModel->countAllResults(false),
        ];

        return view('educations/index', $data);
    }
}
