<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;
use App\Models\ActivityModel;
use App\Models\EducationModel;

class DashboardController extends BaseController
{
    protected $biodataModel;
    protected $activityModel;
    protected $educationModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        $this->activityModel = new ActivityModel();
        $this->educationModel = new EducationModel();
    }

    public function index()
    {
        $data = [
            'title'               => 'Dashboard',
            'biodata'             => $this->biodataModel->getBiodata(),
            'totalActivities'     => $this->activityModel->countAllResults(),
            'publishedActivities' => $this->activityModel->countByStatus('published'),
            'draftActivities'     => $this->activityModel->countByStatus('draft'),
            'totalEducations'     => $this->educationModel->countAllResults(),
            'ongoingEducations'   => $this->educationModel->countByStatus('ongoing'),
            'completedEducations' => $this->educationModel->countByStatus('completed'),
            'recentActivities'    => $this->activityModel
                                        ->orderBy('created_at', 'DESC')
                                        ->limit(5)
                                        ->findAll(),
        ];

        return view('admin/dashboard', $data);
    }
}
