<?= $this->extend('layout/template'); ?>

<?= $this->section('content'); ?>

<!-- Hero Section -->
<div class="hero-section mb-5">
    <div class="text-center fade-in-up">
        <div class="icon-box-modern mx-auto mb-4" style="width: 80px; height: 80px; font-size: 2.5rem;">
            <i class="bi bi-activity"></i>
        </div>
        <h1 class="display-4 fw-bold text-gradient-pink mb-3">Aktivitas Harian</h1>
        <p class="lead text-muted mb-4">Catatan kegiatan, pencapaian, dan produktivitas harian</p>
        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <span class="badge badge-pink fs-6 px-3 py-2">
                <i class="bi bi-calendar-check me-2"></i>Kegiatan Harian
            </span>
            <span class="badge bg-light text-dark fs-6 px-3 py-2">
                <i class="bi bi-graph-up me-2"></i>Tracking Produktivitas
            </span>
        </div>
    </div>
</div>

<div class="container">
    <!-- Filter -->
    <div class="card card-pink-glow rounded-4 mb-5 border-0 fade-in-up delay-100 mx-auto" style="max-width: 900px;">
        <div class="card-header bg-gradient-pink-soft border-0 py-3">
            <h5 class="mb-0 text-primary">
                <i class="bi bi-funnel me-2"></i>Filter & Pencarian Aktivitas
            </h5>
        </div>
        <div class="card-body p-4">
            <form action="<?= base_url('/aktivitas'); ?>" method="get">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label small text-muted fw-bold">CARI AKTIVITAS</label>
                        <div class="input-group">
                            <span class="input-group-text bg-white border-end-0">
                                <i class="bi bi-search text-primary"></i>
                            </span>
                            <input type="text" class="form-control form-control-pink border-start-0 ps-0" 
                                   name="keyword" placeholder="Nama aktivitas..." value="<?= esc($keyword); ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label small text-muted fw-bold">URUTAN</label>
                        <select class="form-select form-control-pink" name="order">
                            <option value="DESC" <?= $order == 'DESC' ? 'selected' : ''; ?>>Terbaru Dulu</option>
                            <option value="ASC" <?= $order == 'ASC' ? 'selected' : ''; ?>>Terlama Dulu</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small text-muted fw-bold">AKSI</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-pink-gradient flex-grow-1">
                                <i class="bi bi-search"></i>
                            </button>
                            <a href="<?= base_url('/aktivitas'); ?>" class="btn btn-pink-outline" title="Reset Filter">
                                <i class="bi bi-arrow-counterclockwise"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Activity Grid -->
    <div class="fade-in-up delay-200">
        <?php if(empty($aktivitas)): ?>
            <div class="text-center py-5 fade-in-up">
                <div class="stat-card-pink mx-auto mb-4" style="width: 200px; padding: 2rem;">
                    <i class="bi bi-calendar-x fs-1 mb-3"></i>
                    <h5 class="fw-bold">Tidak Ada Aktivitas</h5>
                </div>
                <h4 class="text-gradient-pink fw-bold mb-3">Belum Ada Aktivitas Tercatat</h4>
                <p class="text-muted mb-4">Mulai catat aktivitas harian Anda untuk tracking produktivitas.</p>
                <a href="<?= base_url('/admin/aktivitas'); ?>" class="btn btn-pink-gradient">
                    <i class="bi bi-plus-circle me-2"></i>Tambah Aktivitas Pertama
                </a>
            </div>
        <?php else: ?>
            <!-- Stats Summary -->
            <div class="row g-4 mb-5 fade-in-up delay-200">
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-list-check"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0"><?= count($aktivitas); ?></h5>
                        <small class="text-muted">Total Aktivitas</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-calendar-week"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0">
                            <?php 
                            $dates = array_unique(array_column($aktivitas, 'tanggal'));
                            echo count($dates);
                            ?>
                        </h5>
                        <small class="text-muted">Hari Aktif</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-calendar-event"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0">
                            <?= !empty($aktivitas) ? date('d/m', strtotime(min(array_column($aktivitas, 'tanggal')))) : '-'; ?>
                        </h5>
                        <small class="text-muted">Aktivitas Pertama</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0">
                            <?= !empty($aktivitas) ? date('d/m', strtotime(max(array_column($aktivitas, 'tanggal')))) : '-'; ?>
                        </h5>
                        <small class="text-muted">Aktivitas Terakhir</small>
                    </div>
                </div>
            </div>

            <div class="activity-grid">
                <?php foreach ($aktivitas as $key => $act): ?>
                    <div class="card card-pink-glow h-100 hover-card reveal" style="animation-delay: <?= ($key * 0.1) ?>s;">
                        <div class="card-body p-4 position-relative">
                            <!-- Floating Date Badge -->
                            <div class="position-absolute top-0 end-0 m-3">
                                <div class="badge badge-pink rounded-pill px-3 py-2">
                                    <i class="bi bi-calendar-event me-1"></i>
                                    <?= date('d M Y', strtotime($act['tanggal'])); ?>
                                </div>
                            </div>
                            
                            <div class="d-flex align-items-start mb-3">
                                <div class="icon-box-modern me-3 flex-shrink-0">
                                    <i class="bi bi-activity"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h5 class="text-gradient-pink fw-bold mb-2 pe-4">
                                        <?= esc($act['nama_aktivitas']); ?>
                                    </h5>
                                    <small class="text-muted">
                                        <i class="bi bi-clock me-1"></i>
                                        <?= date('H:i', strtotime($act['created_at'] ?? 'now')); ?> WIB
                                    </small>
                                </div>
                            </div>
                            
                            <?php if(!empty($act['keterangan'])): ?>
                                <div class="bg-gradient-pink-soft rounded-3 p-3 mb-3">
                                    <p class="mb-0 small text-muted line-clamp-3">
                                        <i class="bi bi-info-circle-fill text-primary me-2"></i>
                                        <?= nl2br(esc($act['keterangan'])); ?>
                                    </p>
                                </div>
                            <?php endif; ?>
                            
                            <div class="d-flex justify-content-between align-items-center mt-auto pt-3 border-top" style="border-color: rgba(139, 92, 246, 0.1) !important;">
                                <small class="text-muted">
                                    <i class="bi bi-tag me-1"></i>Aktivitas Harian
                                </small>
                                <div class="progress progress-pink" style="width: 60px; height: 4px;">
                                    <div class="progress-bar" style="width: 100%;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Pagination -->
            <?php if(isset($pager)): ?>
                <div class="d-flex justify-content-center mt-5 fade-in-up">
                    <div class="pagination-pink">
                        <?= $pager->links('aktivitas', 'default_full'); ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?= $this->endSection(); ?>
