<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        :root {
            --primary-hue: 247;
            --primary-saturation: 80%;
            --primary-lightness: 60%;
            --primary-color: hsl(var(--primary-hue), var(--primary-saturation), var(--primary-lightness));
            --primary-color-dark: hsl(var(--primary-hue), var(--primary-saturation), 50%);
            --primary-color-glow: hsla(var(--primary-hue), var(--primary-saturation), var(--primary-lightness), 0.4);
            --background-color: #f0f2f5;
            --card-background: #ffffff;
            --text-color: #333;
            --muted-text-color: #6c757d;
            --border-color: #dee2e6;
        }
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            background-color: var(--background-color);
            color: var(--text-color);
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .login-container {
            width: 100%;
            max-width: 420px;
            padding: 1.5rem;
        }
        .login-card {
            background-color: var(--card-background);
            border-radius: 12px;
            padding: 2.5rem 3rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        .login-card::before {
            content: '';
            position: absolute;
            top: -100px;
            left: -100px;
            width: 250px;
            height: 250px;
            background: radial-gradient(circle, var(--primary-color-glow), transparent 70%);
            opacity: 0.5;
            pointer-events: none;
        }
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
            position: relative;
            z-index: 1;
        }
        .login-header .icon {
            display: inline-flex;
            justify-content: center;
            align-items: center;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(145deg, var(--primary-color), var(--primary-color-dark));
            color: white;
            font-size: 1.75rem;
            margin-bottom: 1rem;
            box-shadow: 0 4px 15px var(--primary-color-glow);
        }
        .login-header h1 {
            font-size: 1.75rem;
            font-weight: 600;
            margin: 0;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .input-group {
            position: relative;
            display: flex;
            align-items: stretch;
            width: 100%;
        }
        .form-control {
            display: block;
            width: 100%;
            padding: 0.75rem 1.1rem;
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: var(--text-color);
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid var(--border-color);
            appearance: none;
            border-radius: 0.375rem;
            transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
            z-index: 1;
        }
        .input-group .form-control {
            position: relative;
        }
        .input-group-text {
            display: flex;
            align-items: center;
            padding: 0.75rem 1rem;
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
            color: var(--muted-text-color);
            text-align: center;
            white-space: nowrap;
            background-color: #e9ecef;
            border: 1px solid var(--border-color);
            border-radius: 0.375rem;
        }
        .input-group .form-control:focus {
            z-index: 3;
            outline: 0;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 4px var(--primary-color-glow);
        }
        .input-group > :not(:first-child) { border-top-left-radius: 0; border-bottom-left-radius: 0; }
        .input-group > :not(:last-child) { border-top-right-radius: 0; border-bottom-right-radius: 0; }
        .input-group-text { border-right: 0; }
        .input-group .form-control { border-left: 0; }
        #togglePassword { z-index: 3; cursor: pointer; }

        .btn {
            display: inline-block;
            width: 100%;
            font-weight: 600;
            line-height: 1.5;
            text-align: center;
            text-decoration: none;
            vertical-align: middle;
            cursor: pointer;
            user-select: none;
            border: 1px solid transparent;
            padding: 0.8rem 1rem;
            font-size: 1rem;
            border-radius: 0.375rem;
            transition: all .15s ease-in-out;
        }
        .btn-primary {
            color: #fff;
            background: linear-gradient(145deg, var(--primary-color), var(--primary-color-dark));
            box-shadow: 0 4px 15px var(--primary-color-glow);
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 7px 20px var(--primary-color-glow);
        }
        .alert {
            position: relative;
            padding: 1rem 1rem;
            margin-bottom: 1rem;
            border: 1px solid transparent;
            border-radius: 0.375rem;
        }
        .alert-danger {
            color: #842029;
            background-color: #f8d7da;
            border-color: #f5c2c7;
        }
        .text-center { text-align: center; }
        .small { font-size: 0.875em; }
        .text-muted { color: var(--muted-text-color) !important; }
        a { text-decoration: none; color: var(--primary-color); }
        a:hover { color: var(--primary-color-dark); }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="icon"><i class="bi bi-shield-lock-fill"></i></div>
                <h1>Admin Panel</h1>
            </div>

            <?php if(session()->getFlashdata('message')) : ?>
                <div class="alert alert-danger" role="alert">
                    <?= session()->getFlashdata('message'); ?>
                </div>
            <?php endif; ?>

            <form action="<?= base_url('auth/attemptLogin'); ?>" method="post">
                <?= csrf_field(); ?>

                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
                        <input type="text" class="form-control" id="username" name="username" placeholder="Username" value="<?= old('username'); ?>" required autofocus>
                    </div>
                </div>

                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-key-fill"></i></span>
                        <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                        <span class="input-group-text" id="togglePassword"><i class="bi bi-eye-slash-fill"></i></span>
                    </div>
                </div>

                <div class="form-group" style="margin-top: 2rem;">
                    <button type="submit" class="btn btn-primary">Login</button>
                </div>
                
                <div class="text-center">
                    <a href="<?= base_url('/'); ?>" class="small text-muted">&larr; Back to Website</a>
                </div>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const togglePassword = document.querySelector('#togglePassword');
            const password = document.querySelector('#password');

            if (togglePassword) {
                togglePassword.addEventListener('click', function (e) {
                    const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
                    password.setAttribute('type', type);
                    
                    const icon = this.querySelector('i');
                    icon.classList.toggle('bi-eye-slash-fill');
                    icon.classList.toggle('bi-eye-fill');
                });
            }
        });
    </script>
</body>
</html>
