<?= $this->extend('layout/admin_template'); ?>

<?= $this->section('content'); ?>

<div class="mb-5 fade-in-up">
    <h1 class="fw-bold mb-2">Dashboard Overview</h1>
    <p class="text-muted">Welcome back, Administrator.</p>
</div>

<div class="row g-4">
    <!-- Biodata Stat -->
    <div class="col-md-4">
        <div class="card card-feature border-0 rounded-4 h-100 fade-in-up delay-100">
            <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="icon-box-modern me-3 flex-shrink-0">
                         <i class="bi bi-person-badge-fill"></i>
                    </div>
                    <div>
                        <p class="text-muted small mb-1">Biodata Status</p>
                        <h4 class="fw-bold mb-0"><?= $has_biodata ? 'Active' : 'Empty'; ?></h4>
                    </div>
                </div>
                <hr class="opacity-10 my-3">
                <a href="<?= base_url('admin/biodata'); ?>" class="btn btn-sm btn-light text-primary rounded-pill px-3 fw-bold w-100">Manage Biodata <i class="bi bi-arrow-right ms-1"></i></a>
            </div>
        </div>
    </div>
    
    <!-- Pendidikan Stat -->
    <div class="col-md-4">
        <div class="card card-feature border-0 rounded-4 h-100 fade-in-up delay-200">
             <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="icon-box-modern me-3 flex-shrink-0" style="color: var(--secondary-color);">
                         <i class="bi bi-mortarboard-fill"></i>
                    </div>
                    <div>
                        <p class="text-muted small mb-1">Total Education</p>
                        <h4 class="fw-bold mb-0"><?= $count_pendidikan; ?> Records</h4>
                    </div>
                </div>
                <hr class="opacity-10 my-3">
                <a href="<?= base_url('admin/pendidikan'); ?>" class="btn btn-sm btn-light text-secondary rounded-pill px-3 fw-bold w-100">View Timeline <i class="bi bi-arrow-right ms-1"></i></a>
            </div>
        </div>
    </div>

    <!-- Aktivitas Stat -->
    <div class="col-md-4">
        <div class="card card-feature border-0 rounded-4 h-100 fade-in-up delay-300">
             <div class="card-body p-4">
                <div class="d-flex align-items-center">
                    <div class="icon-box-modern me-3 flex-shrink-0" style="color: #ea580c;">
                         <i class="bi bi-activity"></i>
                    </div>
                    <div>
                        <p class="text-muted small mb-1">Total Activities</p>
                        <h4 class="fw-bold mb-0"><?= $count_aktivitas; ?> Logs</h4>
                    </div>
                </div>
                <hr class="opacity-10 my-3">
                <a href="<?= base_url('admin/aktivitas'); ?>" class="btn btn-sm btn-light text-warning rounded-pill px-3 fw-bold w-100">Check Log <i class="bi bi-arrow-right ms-1"></i></a>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection(); ?>
